@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property iscsis An endpoint for accessing data on your storage virtual machine via iSCSI protocol. See Endpoint.
 * @property managements An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
 * @property nfs An endpoint for accessing data on your storage virtual machine via NFS protocol. See Endpoint.
 * @property smbs An endpoint for accessing data on your storage virtual machine via SMB protocol. This is only set if an active_directory_configuration has been set. See Endpoint.
 */
public data class OntapStorageVirtualMachineEndpoint(
    public val iscsis: List<OntapStorageVirtualMachineEndpointIscsi>? = null,
    public val managements: List<OntapStorageVirtualMachineEndpointManagement>? = null,
    public val nfs: List<OntapStorageVirtualMachineEndpointNf>? = null,
    public val smbs: List<OntapStorageVirtualMachineEndpointSmb>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapStorageVirtualMachineEndpoint): OntapStorageVirtualMachineEndpoint = OntapStorageVirtualMachineEndpoint(
            iscsis = javaType.iscsis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineEndpointIscsi.Companion.toKotlin(args0)
                })
            }),
            managements = javaType.managements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineEndpointManagement.Companion.toKotlin(args0)
                })
            }),
            nfs = javaType.nfs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineEndpointNf.Companion.toKotlin(args0)
                })
            }),
            smbs = javaType.smbs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineEndpointSmb.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
