@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsName The Domain Name Service (DNS) name for the storage virtual machine. You can mount your storage virtual machine using its DNS name.
 * @property ipAddresses IP addresses of the storage virtual machine endpoint.
 */
public data class OntapStorageVirtualMachineEndpointSmb(
    public val dnsName: String? = null,
    public val ipAddresses: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapStorageVirtualMachineEndpointSmb): OntapStorageVirtualMachineEndpointSmb = OntapStorageVirtualMachineEndpointSmb(
            dnsName = javaType.dnsName().map({ args0 -> args0 }).orElse(null),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
        )
    }
}
