@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aggregates Used to specify the names of the aggregates on which the volume will be created. Each aggregate needs to be in the format aggrX where X is the number of the aggregate.
 * @property constituentsPerAggregate Used to explicitly set the number of constituents within the FlexGroup per storage aggregate. the default value is `8`.
 * @property totalConstituents The total amount of constituents for a `FLEXGROUP` volume. This would equal constituents_per_aggregate x aggregates.
 */
public data class OntapVolumeAggregateConfiguration(
    public val aggregates: List<String>? = null,
    public val constituentsPerAggregate: Int? = null,
    public val totalConstituents: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapVolumeAggregateConfiguration): OntapVolumeAggregateConfiguration = OntapVolumeAggregateConfiguration(
            aggregates = javaType.aggregates().map({ args0 -> args0 }),
            constituentsPerAggregate = javaType.constituentsPerAggregate().map({ args0 -> args0 }).orElse(null),
            totalConstituents = javaType.totalConstituents().map({ args0 -> args0 }).orElse(null),
        )
    }
}
