@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property auditLogVolume Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`.
 * @property autocommitPeriod The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See `autocommit_period` Block for details.
 * @property privilegedDelete Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Valid values: `DISABLED`, `ENABLED`, `PERMANENTLY_DISABLED`. The default value is `DISABLED`.
 * @property retentionPeriod The retention period of an FSx for ONTAP SnapLock volume. See `retention_period` Block for details.
 * @property snaplockType Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Valid values: `COMPLIANCE`, `ENTERPRISE`.
 * @property volumeAppendModeEnabled Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. The default value is `false`.
 */
public data class OntapVolumeSnaplockConfiguration(
    public val auditLogVolume: Boolean? = null,
    public val autocommitPeriod: OntapVolumeSnaplockConfigurationAutocommitPeriod? = null,
    public val privilegedDelete: String? = null,
    public val retentionPeriod: OntapVolumeSnaplockConfigurationRetentionPeriod? = null,
    public val snaplockType: String,
    public val volumeAppendModeEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapVolumeSnaplockConfiguration): OntapVolumeSnaplockConfiguration = OntapVolumeSnaplockConfiguration(
            auditLogVolume = javaType.auditLogVolume().map({ args0 -> args0 }).orElse(null),
            autocommitPeriod = javaType.autocommitPeriod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeSnaplockConfigurationAutocommitPeriod.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privilegedDelete = javaType.privilegedDelete().map({ args0 -> args0 }).orElse(null),
            retentionPeriod = javaType.retentionPeriod().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeSnaplockConfigurationRetentionPeriod.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snaplockType = javaType.snaplockType(),
            volumeAppendModeEnabled = javaType.volumeAppendModeEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
