@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property defaultRetention The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period. See `default_retention` Block for details.
 * @property maximumRetention The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See `maximum_retention` Block for details.
 * @property minimumRetention The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume. See `minimum_retention` Block for details.
 */
public data class OntapVolumeSnaplockConfigurationRetentionPeriod(
    public val defaultRetention: OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetention? =
        null,
    public val maximumRetention: OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetention? =
        null,
    public val minimumRetention: OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapVolumeSnaplockConfigurationRetentionPeriod): OntapVolumeSnaplockConfigurationRetentionPeriod =
            OntapVolumeSnaplockConfigurationRetentionPeriod(
                defaultRetention = javaType.defaultRetention().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeSnaplockConfigurationRetentionPeriodDefaultRetention.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                maximumRetention = javaType.maximumRetention().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetention.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                minimumRetention = javaType.minimumRetention().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
