@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property type The type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the valid types. If you set it to `INFINITE`, the files are retained forever. If you set it to `UNSPECIFIED`, the files are retained until you set an explicit retention period. Valid values: `SECONDS`, `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `INFINITE`, `UNSPECIFIED`.
 * @property value The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
 */
public data class OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention(
    public val type: String? = null,
    public val `value`: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention): OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention =
            OntapVolumeSnaplockConfigurationRetentionPeriodMinimumRetention(
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            )
    }
}
