@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clients A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
 * @property options The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
 */
public data class OpenZfsVolumeNfsExportsClientConfiguration(
    public val clients: String,
    public val options: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OpenZfsVolumeNfsExportsClientConfiguration): OpenZfsVolumeNfsExportsClientConfiguration = OpenZfsVolumeNfsExportsClientConfiguration(
            clients = javaType.clients(),
            options = javaType.options().map({ args0 -> args0 }),
        )
    }
}
