@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property copyStrategy Specifies the strategy used when copying data from the snapshot to the new volume. Valid values are `CLONE`, `FULL_COPY`, `INCREMENTAL_COPY`.
 * @property snapshotArn The Amazon Resource Name (ARN) of the origin snapshot.
 */
public data class OpenZfsVolumeOriginSnapshot(
    public val copyStrategy: String,
    public val snapshotArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OpenZfsVolumeOriginSnapshot): OpenZfsVolumeOriginSnapshot = OpenZfsVolumeOriginSnapshot(
            copyStrategy = javaType.copyStrategy(),
            snapshotArn = javaType.snapshotArn(),
        )
    }
}
