@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.AliasArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.AliasRoutingStrategyArgs
import com.pulumi.aws.gamelift.kotlin.inputs.AliasRoutingStrategyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a GameLift Alias resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.gamelift.Alias("example", {
 *     name: "example-alias",
 *     description: "Example Description",
 *     routingStrategy: {
 *         message: "Example Message",
 *         type: "TERMINAL",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.gamelift.Alias("example",
 *     name="example-alias",
 *     description="Example Description",
 *     routing_strategy={
 *         "message": "Example Message",
 *         "type": "TERMINAL",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GameLift.Alias("example", new()
 *     {
 *         Name = "example-alias",
 *         Description = "Example Description",
 *         RoutingStrategy = new Aws.GameLift.Inputs.AliasRoutingStrategyArgs
 *         {
 *             Message = "Example Message",
 *             Type = "TERMINAL",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewAlias(ctx, "example", &gamelift.AliasArgs{
 * 			Name:        pulumi.String("example-alias"),
 * 			Description: pulumi.String("Example Description"),
 * 			RoutingStrategy: &gamelift.AliasRoutingStrategyArgs{
 * 				Message: pulumi.String("Example Message"),
 * 				Type:    pulumi.String("TERMINAL"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Alias;
 * import com.pulumi.aws.gamelift.AliasArgs;
 * import com.pulumi.aws.gamelift.inputs.AliasRoutingStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Alias("example", AliasArgs.builder()
 *             .name("example-alias")
 *             .description("Example Description")
 *             .routingStrategy(AliasRoutingStrategyArgs.builder()
 *                 .message("Example Message")
 *                 .type("TERMINAL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:gamelift:Alias
 *     properties:
 *       name: example-alias
 *       description: Example Description
 *       routingStrategy:
 *         message: Example Message
 *         type: TERMINAL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Aliases using the ID. For example:
 * ```sh
 * $ pulumi import aws:gamelift/alias:Alias example <alias-id>
 * ```
 * @property description Description of the alias.
 * @property name Name of the alias.
 * @property routingStrategy Specifies the fleet and/or routing type to use for the alias.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AliasArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routingStrategy: Output<AliasRoutingStrategyArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.AliasArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.AliasArgs =
        com.pulumi.aws.gamelift.AliasArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .routingStrategy(routingStrategy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AliasArgs].
 */
@PulumiTagMarker
public class AliasArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var routingStrategy: Output<AliasRoutingStrategyArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the alias.
     */
    @JvmName("duaxyrbpgtwtauuh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the alias.
     */
    @JvmName("twaxhudniqbpuosy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the fleet and/or routing type to use for the alias.
     */
    @JvmName("tckdcaogjcqpntcn")
    public suspend fun routingStrategy(`value`: Output<AliasRoutingStrategyArgs>) {
        this.routingStrategy = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vujrmkteqabgceyr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the alias.
     */
    @JvmName("kpevrondhhphoxlw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the alias.
     */
    @JvmName("tikpsgaurhhyaubo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the fleet and/or routing type to use for the alias.
     */
    @JvmName("ojtvsqhtxqixxcbx")
    public suspend fun routingStrategy(`value`: AliasRoutingStrategyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingStrategy = mapped
    }

    /**
     * @param argument Specifies the fleet and/or routing type to use for the alias.
     */
    @JvmName("pwfvjpcksfkdgxtx")
    public suspend fun routingStrategy(argument: suspend AliasRoutingStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = AliasRoutingStrategyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingStrategy = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mlbrebpmrxmixdjx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lsdvioajrdvlbcqf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AliasArgs = AliasArgs(
        description = description,
        name = name,
        routingStrategy = routingStrategy,
        tags = tags,
    )
}
