@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.kotlin.outputs.BuildStorageLocation
import com.pulumi.aws.gamelift.kotlin.outputs.BuildStorageLocation.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Build].
 */
@PulumiTagMarker
public class BuildResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BuildArgs = BuildArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BuildArgsBuilder.() -> Unit) {
        val builder = BuildArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Build {
        val builtJavaResource = com.pulumi.aws.gamelift.Build(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Build(builtJavaResource)
    }
}

/**
 * Provides an GameLift Build resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.gamelift.Build("test", {
 *     name: "example-build",
 *     operatingSystem: "WINDOWS_2012",
 *     storageLocation: {
 *         bucket: testAwsS3Bucket.id,
 *         key: testAwsS3Object.key,
 *         roleArn: testAwsIamRole.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.gamelift.Build("test",
 *     name="example-build",
 *     operating_system="WINDOWS_2012",
 *     storage_location={
 *         "bucket": test_aws_s3_bucket["id"],
 *         "key": test_aws_s3_object["key"],
 *         "role_arn": test_aws_iam_role["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.GameLift.Build("test", new()
 *     {
 *         Name = "example-build",
 *         OperatingSystem = "WINDOWS_2012",
 *         StorageLocation = new Aws.GameLift.Inputs.BuildStorageLocationArgs
 *         {
 *             Bucket = testAwsS3Bucket.Id,
 *             Key = testAwsS3Object.Key,
 *             RoleArn = testAwsIamRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewBuild(ctx, "test", &gamelift.BuildArgs{
 * 			Name:            pulumi.String("example-build"),
 * 			OperatingSystem: pulumi.String("WINDOWS_2012"),
 * 			StorageLocation: &gamelift.BuildStorageLocationArgs{
 * 				Bucket:  pulumi.Any(testAwsS3Bucket.Id),
 * 				Key:     pulumi.Any(testAwsS3Object.Key),
 * 				RoleArn: pulumi.Any(testAwsIamRole.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Build;
 * import com.pulumi.aws.gamelift.BuildArgs;
 * import com.pulumi.aws.gamelift.inputs.BuildStorageLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Build("test", BuildArgs.builder()
 *             .name("example-build")
 *             .operatingSystem("WINDOWS_2012")
 *             .storageLocation(BuildStorageLocationArgs.builder()
 *                 .bucket(testAwsS3Bucket.id())
 *                 .key(testAwsS3Object.key())
 *                 .roleArn(testAwsIamRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:gamelift:Build
 *     properties:
 *       name: example-build
 *       operatingSystem: WINDOWS_2012
 *       storageLocation:
 *         bucket: ${testAwsS3Bucket.id}
 *         key: ${testAwsS3Object.key}
 *         roleArn: ${testAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Builds using the ID. For example:
 * ```sh
 * $ pulumi import aws:gamelift/build:Build example <build-id>
 * ```
 */
public class Build internal constructor(
    override val javaResource: com.pulumi.aws.gamelift.Build,
) : KotlinCustomResource(javaResource, BuildMapper) {
    /**
     * GameLift Build ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the build
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operating system that the game server binaries are built to run on. Valid values: `WINDOWS_2012`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `WINDOWS_2016`, `AMAZON_LINUX_2023`.
     */
    public val operatingSystem: Output<String>
        get() = javaResource.operatingSystem().applyValue({ args0 -> args0 })

    /**
     * Information indicating where your game build files are stored. See below.
     */
    public val storageLocation: Output<BuildStorageLocation>
        get() = javaResource.storageLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Version that is associated with this build.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BuildMapper : ResourceMapper<Build> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.gamelift.Build::class == javaResource::class

    override fun map(javaResource: Resource): Build = Build(
        javaResource as
            com.pulumi.aws.gamelift.Build,
    )
}

/**
 * @see [Build].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Build].
 */
public suspend fun build(name: String, block: suspend BuildResourceBuilder.() -> Unit): Build {
    val builder = BuildResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Build].
 * @param name The _unique_ name of the resulting resource.
 */
public fun build(name: String): Build {
    val builder = BuildResourceBuilder()
    builder.name(name)
    return builder.build()
}
