@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.BuildArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.BuildStorageLocationArgs
import com.pulumi.aws.gamelift.kotlin.inputs.BuildStorageLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an GameLift Build resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.gamelift.Build("test", {
 *     name: "example-build",
 *     operatingSystem: "WINDOWS_2012",
 *     storageLocation: {
 *         bucket: testAwsS3Bucket.id,
 *         key: testAwsS3Object.key,
 *         roleArn: testAwsIamRole.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.gamelift.Build("test",
 *     name="example-build",
 *     operating_system="WINDOWS_2012",
 *     storage_location={
 *         "bucket": test_aws_s3_bucket["id"],
 *         "key": test_aws_s3_object["key"],
 *         "role_arn": test_aws_iam_role["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.GameLift.Build("test", new()
 *     {
 *         Name = "example-build",
 *         OperatingSystem = "WINDOWS_2012",
 *         StorageLocation = new Aws.GameLift.Inputs.BuildStorageLocationArgs
 *         {
 *             Bucket = testAwsS3Bucket.Id,
 *             Key = testAwsS3Object.Key,
 *             RoleArn = testAwsIamRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewBuild(ctx, "test", &gamelift.BuildArgs{
 * 			Name:            pulumi.String("example-build"),
 * 			OperatingSystem: pulumi.String("WINDOWS_2012"),
 * 			StorageLocation: &gamelift.BuildStorageLocationArgs{
 * 				Bucket:  pulumi.Any(testAwsS3Bucket.Id),
 * 				Key:     pulumi.Any(testAwsS3Object.Key),
 * 				RoleArn: pulumi.Any(testAwsIamRole.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Build;
 * import com.pulumi.aws.gamelift.BuildArgs;
 * import com.pulumi.aws.gamelift.inputs.BuildStorageLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Build("test", BuildArgs.builder()
 *             .name("example-build")
 *             .operatingSystem("WINDOWS_2012")
 *             .storageLocation(BuildStorageLocationArgs.builder()
 *                 .bucket(testAwsS3Bucket.id())
 *                 .key(testAwsS3Object.key())
 *                 .roleArn(testAwsIamRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:gamelift:Build
 *     properties:
 *       name: example-build
 *       operatingSystem: WINDOWS_2012
 *       storageLocation:
 *         bucket: ${testAwsS3Bucket.id}
 *         key: ${testAwsS3Object.key}
 *         roleArn: ${testAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Builds using the ID. For example:
 * ```sh
 * $ pulumi import aws:gamelift/build:Build example <build-id>
 * ```
 * @property name Name of the build
 * @property operatingSystem Operating system that the game server binaries are built to run on. Valid values: `WINDOWS_2012`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `WINDOWS_2016`, `AMAZON_LINUX_2023`.
 * @property storageLocation Information indicating where your game build files are stored. See below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property version Version that is associated with this build.
 */
public data class BuildArgs(
    public val name: Output<String>? = null,
    public val operatingSystem: Output<String>? = null,
    public val storageLocation: Output<BuildStorageLocationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.BuildArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.BuildArgs =
        com.pulumi.aws.gamelift.BuildArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .operatingSystem(operatingSystem?.applyValue({ args0 -> args0 }))
            .storageLocation(storageLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildArgs].
 */
@PulumiTagMarker
public class BuildArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var operatingSystem: Output<String>? = null

    private var storageLocation: Output<BuildStorageLocationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Name of the build
     */
    @JvmName("bsewasayrordwvqe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Operating system that the game server binaries are built to run on. Valid values: `WINDOWS_2012`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `WINDOWS_2016`, `AMAZON_LINUX_2023`.
     */
    @JvmName("uflexoaruvjmoxfi")
    public suspend fun operatingSystem(`value`: Output<String>) {
        this.operatingSystem = value
    }

    /**
     * @param value Information indicating where your game build files are stored. See below.
     */
    @JvmName("depbqcsdkgutiran")
    public suspend fun storageLocation(`value`: Output<BuildStorageLocationArgs>) {
        this.storageLocation = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("anmmyifncefhwqpd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Version that is associated with this build.
     */
    @JvmName("pcfygamiqopqgcas")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of the build
     */
    @JvmName("uvwvglhbeghqilsl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Operating system that the game server binaries are built to run on. Valid values: `WINDOWS_2012`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `WINDOWS_2016`, `AMAZON_LINUX_2023`.
     */
    @JvmName("srpdqqxivkiycqlb")
    public suspend fun operatingSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystem = mapped
    }

    /**
     * @param value Information indicating where your game build files are stored. See below.
     */
    @JvmName("qanxbinkyompcwls")
    public suspend fun storageLocation(`value`: BuildStorageLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLocation = mapped
    }

    /**
     * @param argument Information indicating where your game build files are stored. See below.
     */
    @JvmName("bluqauclflufnqsr")
    public suspend fun storageLocation(argument: suspend BuildStorageLocationArgsBuilder.() -> Unit) {
        val toBeMapped = BuildStorageLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageLocation = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ovnlrdudlcpujljc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nosehpnsthljmsyo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Version that is associated with this build.
     */
    @JvmName("kphgosvlvnvlkome")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): BuildArgs = BuildArgs(
        name = name,
        operatingSystem = operatingSystem,
        storageLocation = storageLocation,
        tags = tags,
        version = version,
    )
}
