@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.kotlin.outputs.FleetCertificateConfiguration
import com.pulumi.aws.gamelift.kotlin.outputs.FleetEc2InboundPermission
import com.pulumi.aws.gamelift.kotlin.outputs.FleetResourceCreationLimitPolicy
import com.pulumi.aws.gamelift.kotlin.outputs.FleetRuntimeConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.gamelift.kotlin.outputs.FleetCertificateConfiguration.Companion.toKotlin as fleetCertificateConfigurationToKotlin
import com.pulumi.aws.gamelift.kotlin.outputs.FleetEc2InboundPermission.Companion.toKotlin as fleetEc2InboundPermissionToKotlin
import com.pulumi.aws.gamelift.kotlin.outputs.FleetResourceCreationLimitPolicy.Companion.toKotlin as fleetResourceCreationLimitPolicyToKotlin
import com.pulumi.aws.gamelift.kotlin.outputs.FleetRuntimeConfiguration.Companion.toKotlin as fleetRuntimeConfigurationToKotlin

/**
 * Builder for [Fleet].
 */
@PulumiTagMarker
public class FleetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FleetArgs = FleetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FleetArgsBuilder.() -> Unit) {
        val builder = FleetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Fleet {
        val builtJavaResource = com.pulumi.aws.gamelift.Fleet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Fleet(builtJavaResource)
    }
}

/**
 * Provides a GameLift Fleet resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.gamelift.Fleet("example", {
 *     buildId: exampleAwsGameliftBuild.id,
 *     ec2InstanceType: "t2.micro",
 *     fleetType: "ON_DEMAND",
 *     name: "example-fleet-name",
 *     runtimeConfiguration: {
 *         serverProcesses: [{
 *             concurrentExecutions: 1,
 *             launchPath: "C:\\game\\GomokuServer.exe",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.gamelift.Fleet("example",
 *     build_id=example_aws_gamelift_build["id"],
 *     ec2_instance_type="t2.micro",
 *     fleet_type="ON_DEMAND",
 *     name="example-fleet-name",
 *     runtime_configuration={
 *         "server_processes": [{
 *             "concurrent_executions": 1,
 *             "launch_path": "C:\\game\\GomokuServer.exe",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GameLift.Fleet("example", new()
 *     {
 *         BuildId = exampleAwsGameliftBuild.Id,
 *         Ec2InstanceType = "t2.micro",
 *         FleetType = "ON_DEMAND",
 *         Name = "example-fleet-name",
 *         RuntimeConfiguration = new Aws.GameLift.Inputs.FleetRuntimeConfigurationArgs
 *         {
 *             ServerProcesses = new[]
 *             {
 *                 new Aws.GameLift.Inputs.FleetRuntimeConfigurationServerProcessArgs
 *                 {
 *                     ConcurrentExecutions = 1,
 *                     LaunchPath = "C:\\game\\GomokuServer.exe",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewFleet(ctx, "example", &gamelift.FleetArgs{
 * 			BuildId:         pulumi.Any(exampleAwsGameliftBuild.Id),
 * 			Ec2InstanceType: pulumi.String("t2.micro"),
 * 			FleetType:       pulumi.String("ON_DEMAND"),
 * 			Name:            pulumi.String("example-fleet-name"),
 * 			RuntimeConfiguration: &gamelift.FleetRuntimeConfigurationArgs{
 * 				ServerProcesses: gamelift.FleetRuntimeConfigurationServerProcessArray{
 * 					&gamelift.FleetRuntimeConfigurationServerProcessArgs{
 * 						ConcurrentExecutions: pulumi.Int(1),
 * 						LaunchPath:           pulumi.String("C:\\game\\GomokuServer.exe"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Fleet;
 * import com.pulumi.aws.gamelift.FleetArgs;
 * import com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example", FleetArgs.builder()
 *             .buildId(exampleAwsGameliftBuild.id())
 *             .ec2InstanceType("t2.micro")
 *             .fleetType("ON_DEMAND")
 *             .name("example-fleet-name")
 *             .runtimeConfiguration(FleetRuntimeConfigurationArgs.builder()
 *                 .serverProcesses(FleetRuntimeConfigurationServerProcessArgs.builder()
 *                     .concurrentExecutions(1)
 *                     .launchPath("C:\\game\\GomokuServer.exe")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:gamelift:Fleet
 *     properties:
 *       buildId: ${exampleAwsGameliftBuild.id}
 *       ec2InstanceType: t2.micro
 *       fleetType: ON_DEMAND
 *       name: example-fleet-name
 *       runtimeConfiguration:
 *         serverProcesses:
 *           - concurrentExecutions: 1
 *             launchPath: C:\game\GomokuServer.exe
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Fleets using the ID. For example:
 * ```sh
 * $ pulumi import aws:gamelift/fleet:Fleet example <fleet-id>
 * ```
 */
public class Fleet internal constructor(
    override val javaResource: com.pulumi.aws.gamelift.Fleet,
) : KotlinCustomResource(javaResource, FleetMapper) {
    /**
     * Fleet ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Build ARN.
     */
    public val buildArn: Output<String>
        get() = javaResource.buildArn().applyValue({ args0 -> args0 })

    /**
     * ID of the GameLift Build to be deployed on the fleet.
     */
    public val buildId: Output<String>?
        get() = javaResource.buildId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
     */
    public val certificateConfiguration: Output<FleetCertificateConfiguration>
        get() = javaResource.certificateConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                fleetCertificateConfigurationToKotlin(args0)
            })
        })

    /**
     * Human-readable description of the fleet.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
     */
    public val ec2InboundPermissions: Output<List<FleetEc2InboundPermission>>
        get() = javaResource.ec2InboundPermissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fleetEc2InboundPermissionToKotlin(args0) })
            })
        })

    /**
     * Name of an EC2 instance typeE.g., `t2.micro`
     */
    public val ec2InstanceType: Output<String>
        get() = javaResource.ec2InstanceType().applyValue({ args0 -> args0 })

    /**
     * Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
     */
    public val fleetType: Output<String>?
        get() = javaResource.fleetType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARN of an IAM role that instances in the fleet can assume.
     */
    public val instanceRoleArn: Output<String>?
        get() = javaResource.instanceRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val logPaths: Output<List<String>>
        get() = javaResource.logPaths().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
     */
    public val metricGroups: Output<List<String>>
        get() = javaResource.metricGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the fleet.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
     */
    public val newGameSessionProtectionPolicy: Output<String>?
        get() = javaResource.newGameSessionProtectionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operating system of the fleet's computing resources.
     */
    public val operatingSystem: Output<String>
        get() = javaResource.operatingSystem().applyValue({ args0 -> args0 })

    /**
     * Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
     */
    public val resourceCreationLimitPolicy: Output<FleetResourceCreationLimitPolicy>?
        get() = javaResource.resourceCreationLimitPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fleetResourceCreationLimitPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Instructions for launching server processes on each instance in the fleet. See below.
     */
    public val runtimeConfiguration: Output<FleetRuntimeConfiguration>?
        get() = javaResource.runtimeConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fleetRuntimeConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Script ARN.
     */
    public val scriptArn: Output<String>
        get() = javaResource.scriptArn().applyValue({ args0 -> args0 })

    /**
     * ID of the GameLift Script to be deployed on the fleet.
     */
    public val scriptId: Output<String>?
        get() = javaResource.scriptId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FleetMapper : ResourceMapper<Fleet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.gamelift.Fleet::class == javaResource::class

    override fun map(javaResource: Resource): Fleet = Fleet(
        javaResource as
            com.pulumi.aws.gamelift.Fleet,
    )
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Fleet].
 */
public suspend fun fleet(name: String, block: suspend FleetResourceBuilder.() -> Unit): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fleet(name: String): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    return builder.build()
}
