@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.FleetArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.FleetCertificateConfigurationArgs
import com.pulumi.aws.gamelift.kotlin.inputs.FleetCertificateConfigurationArgsBuilder
import com.pulumi.aws.gamelift.kotlin.inputs.FleetEc2InboundPermissionArgs
import com.pulumi.aws.gamelift.kotlin.inputs.FleetEc2InboundPermissionArgsBuilder
import com.pulumi.aws.gamelift.kotlin.inputs.FleetResourceCreationLimitPolicyArgs
import com.pulumi.aws.gamelift.kotlin.inputs.FleetResourceCreationLimitPolicyArgsBuilder
import com.pulumi.aws.gamelift.kotlin.inputs.FleetRuntimeConfigurationArgs
import com.pulumi.aws.gamelift.kotlin.inputs.FleetRuntimeConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a GameLift Fleet resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.gamelift.Fleet("example", {
 *     buildId: exampleAwsGameliftBuild.id,
 *     ec2InstanceType: "t2.micro",
 *     fleetType: "ON_DEMAND",
 *     name: "example-fleet-name",
 *     runtimeConfiguration: {
 *         serverProcesses: [{
 *             concurrentExecutions: 1,
 *             launchPath: "C:\\game\\GomokuServer.exe",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.gamelift.Fleet("example",
 *     build_id=example_aws_gamelift_build["id"],
 *     ec2_instance_type="t2.micro",
 *     fleet_type="ON_DEMAND",
 *     name="example-fleet-name",
 *     runtime_configuration={
 *         "server_processes": [{
 *             "concurrent_executions": 1,
 *             "launch_path": "C:\\game\\GomokuServer.exe",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GameLift.Fleet("example", new()
 *     {
 *         BuildId = exampleAwsGameliftBuild.Id,
 *         Ec2InstanceType = "t2.micro",
 *         FleetType = "ON_DEMAND",
 *         Name = "example-fleet-name",
 *         RuntimeConfiguration = new Aws.GameLift.Inputs.FleetRuntimeConfigurationArgs
 *         {
 *             ServerProcesses = new[]
 *             {
 *                 new Aws.GameLift.Inputs.FleetRuntimeConfigurationServerProcessArgs
 *                 {
 *                     ConcurrentExecutions = 1,
 *                     LaunchPath = "C:\\game\\GomokuServer.exe",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewFleet(ctx, "example", &gamelift.FleetArgs{
 * 			BuildId:         pulumi.Any(exampleAwsGameliftBuild.Id),
 * 			Ec2InstanceType: pulumi.String("t2.micro"),
 * 			FleetType:       pulumi.String("ON_DEMAND"),
 * 			Name:            pulumi.String("example-fleet-name"),
 * 			RuntimeConfiguration: &gamelift.FleetRuntimeConfigurationArgs{
 * 				ServerProcesses: gamelift.FleetRuntimeConfigurationServerProcessArray{
 * 					&gamelift.FleetRuntimeConfigurationServerProcessArgs{
 * 						ConcurrentExecutions: pulumi.Int(1),
 * 						LaunchPath:           pulumi.String("C:\\game\\GomokuServer.exe"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Fleet;
 * import com.pulumi.aws.gamelift.FleetArgs;
 * import com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example", FleetArgs.builder()
 *             .buildId(exampleAwsGameliftBuild.id())
 *             .ec2InstanceType("t2.micro")
 *             .fleetType("ON_DEMAND")
 *             .name("example-fleet-name")
 *             .runtimeConfiguration(FleetRuntimeConfigurationArgs.builder()
 *                 .serverProcesses(FleetRuntimeConfigurationServerProcessArgs.builder()
 *                     .concurrentExecutions(1)
 *                     .launchPath("C:\\game\\GomokuServer.exe")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:gamelift:Fleet
 *     properties:
 *       buildId: ${exampleAwsGameliftBuild.id}
 *       ec2InstanceType: t2.micro
 *       fleetType: ON_DEMAND
 *       name: example-fleet-name
 *       runtimeConfiguration:
 *         serverProcesses:
 *           - concurrentExecutions: 1
 *             launchPath: C:\game\GomokuServer.exe
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Fleets using the ID. For example:
 * ```sh
 * $ pulumi import aws:gamelift/fleet:Fleet example <fleet-id>
 * ```
 * @property buildId ID of the GameLift Build to be deployed on the fleet.
 * @property certificateConfiguration Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
 * @property description Human-readable description of the fleet.
 * @property ec2InboundPermissions Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
 * @property ec2InstanceType Name of an EC2 instance typeE.g., `t2.micro`
 * @property fleetType Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
 * @property instanceRoleArn ARN of an IAM role that instances in the fleet can assume.
 * @property metricGroups List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
 * @property name The name of the fleet.
 * @property newGameSessionProtectionPolicy Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
 * @property resourceCreationLimitPolicy Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
 * @property runtimeConfiguration Instructions for launching server processes on each instance in the fleet. See below.
 * @property scriptId ID of the GameLift Script to be deployed on the fleet.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FleetArgs(
    public val buildId: Output<String>? = null,
    public val certificateConfiguration: Output<FleetCertificateConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val ec2InboundPermissions: Output<List<FleetEc2InboundPermissionArgs>>? = null,
    public val ec2InstanceType: Output<String>? = null,
    public val fleetType: Output<String>? = null,
    public val instanceRoleArn: Output<String>? = null,
    public val metricGroups: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val newGameSessionProtectionPolicy: Output<String>? = null,
    public val resourceCreationLimitPolicy: Output<FleetResourceCreationLimitPolicyArgs>? = null,
    public val runtimeConfiguration: Output<FleetRuntimeConfigurationArgs>? = null,
    public val scriptId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.FleetArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.FleetArgs =
        com.pulumi.aws.gamelift.FleetArgs.builder()
            .buildId(buildId?.applyValue({ args0 -> args0 }))
            .certificateConfiguration(
                certificateConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .ec2InboundPermissions(
                ec2InboundPermissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ec2InstanceType(ec2InstanceType?.applyValue({ args0 -> args0 }))
            .fleetType(fleetType?.applyValue({ args0 -> args0 }))
            .instanceRoleArn(instanceRoleArn?.applyValue({ args0 -> args0 }))
            .metricGroups(metricGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .newGameSessionProtectionPolicy(newGameSessionProtectionPolicy?.applyValue({ args0 -> args0 }))
            .resourceCreationLimitPolicy(
                resourceCreationLimitPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .runtimeConfiguration(
                runtimeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scriptId(scriptId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FleetArgs].
 */
@PulumiTagMarker
public class FleetArgsBuilder internal constructor() {
    private var buildId: Output<String>? = null

    private var certificateConfiguration: Output<FleetCertificateConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var ec2InboundPermissions: Output<List<FleetEc2InboundPermissionArgs>>? = null

    private var ec2InstanceType: Output<String>? = null

    private var fleetType: Output<String>? = null

    private var instanceRoleArn: Output<String>? = null

    private var metricGroups: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var newGameSessionProtectionPolicy: Output<String>? = null

    private var resourceCreationLimitPolicy: Output<FleetResourceCreationLimitPolicyArgs>? = null

    private var runtimeConfiguration: Output<FleetRuntimeConfigurationArgs>? = null

    private var scriptId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ID of the GameLift Build to be deployed on the fleet.
     */
    @JvmName("hbbgvxpongsqqepg")
    public suspend fun buildId(`value`: Output<String>) {
        this.buildId = value
    }

    /**
     * @param value Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
     */
    @JvmName("ijuhbqemopwbmrci")
    public suspend fun certificateConfiguration(`value`: Output<FleetCertificateConfigurationArgs>) {
        this.certificateConfiguration = value
    }

    /**
     * @param value Human-readable description of the fleet.
     */
    @JvmName("hjlahiivgrwlxaoe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
     */
    @JvmName("bqlqefyixyxecfgk")
    public suspend fun ec2InboundPermissions(`value`: Output<List<FleetEc2InboundPermissionArgs>>) {
        this.ec2InboundPermissions = value
    }

    @JvmName("jiilandtdfrtyybi")
    public suspend fun ec2InboundPermissions(vararg values: Output<FleetEc2InboundPermissionArgs>) {
        this.ec2InboundPermissions = Output.all(values.asList())
    }

    /**
     * @param values Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
     */
    @JvmName("lofgkpnerwpyyinx")
    public suspend fun ec2InboundPermissions(values: List<Output<FleetEc2InboundPermissionArgs>>) {
        this.ec2InboundPermissions = Output.all(values)
    }

    /**
     * @param value Name of an EC2 instance typeE.g., `t2.micro`
     */
    @JvmName("ociwnjkhiedpfwyj")
    public suspend fun ec2InstanceType(`value`: Output<String>) {
        this.ec2InstanceType = value
    }

    /**
     * @param value Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
     */
    @JvmName("aaegstbbbuhvxdwu")
    public suspend fun fleetType(`value`: Output<String>) {
        this.fleetType = value
    }

    /**
     * @param value ARN of an IAM role that instances in the fleet can assume.
     */
    @JvmName("towhyqixvpowghoe")
    public suspend fun instanceRoleArn(`value`: Output<String>) {
        this.instanceRoleArn = value
    }

    /**
     * @param value List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
     */
    @JvmName("eftxalwaqwirhsol")
    public suspend fun metricGroups(`value`: Output<List<String>>) {
        this.metricGroups = value
    }

    @JvmName("nsodjosardbboaqa")
    public suspend fun metricGroups(vararg values: Output<String>) {
        this.metricGroups = Output.all(values.asList())
    }

    /**
     * @param values List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
     */
    @JvmName("symigpfawkurmpid")
    public suspend fun metricGroups(values: List<Output<String>>) {
        this.metricGroups = Output.all(values)
    }

    /**
     * @param value The name of the fleet.
     */
    @JvmName("flahhvsvmyngdrmc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
     */
    @JvmName("vgemdgiasqpiccmb")
    public suspend fun newGameSessionProtectionPolicy(`value`: Output<String>) {
        this.newGameSessionProtectionPolicy = value
    }

    /**
     * @param value Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
     */
    @JvmName("ybojxcvdtrmldlyu")
    public suspend fun resourceCreationLimitPolicy(`value`: Output<FleetResourceCreationLimitPolicyArgs>) {
        this.resourceCreationLimitPolicy = value
    }

    /**
     * @param value Instructions for launching server processes on each instance in the fleet. See below.
     */
    @JvmName("miatqxgfqxyuolgk")
    public suspend fun runtimeConfiguration(`value`: Output<FleetRuntimeConfigurationArgs>) {
        this.runtimeConfiguration = value
    }

    /**
     * @param value ID of the GameLift Script to be deployed on the fleet.
     */
    @JvmName("eyeqlxhvrvvnhcup")
    public suspend fun scriptId(`value`: Output<String>) {
        this.scriptId = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qnnhxqmelmgqdcvy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the GameLift Build to be deployed on the fleet.
     */
    @JvmName("wtdvxvhlktmlcrig")
    public suspend fun buildId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildId = mapped
    }

    /**
     * @param value Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
     */
    @JvmName("ujhgpljobwdoguif")
    public suspend fun certificateConfiguration(`value`: FleetCertificateConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateConfiguration = mapped
    }

    /**
     * @param argument Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
     */
    @JvmName("oskqvnifvptecvam")
    public suspend fun certificateConfiguration(argument: suspend FleetCertificateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FleetCertificateConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.certificateConfiguration = mapped
    }

    /**
     * @param value Human-readable description of the fleet.
     */
    @JvmName("mqdbjlkkmuophrbv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
     */
    @JvmName("cjmnqiskhaoluyns")
    public suspend fun ec2InboundPermissions(`value`: List<FleetEc2InboundPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2InboundPermissions = mapped
    }

    /**
     * @param argument Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
     */
    @JvmName("fjqcvtmfvkmhtauo")
    public suspend fun ec2InboundPermissions(argument: List<suspend FleetEc2InboundPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FleetEc2InboundPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2InboundPermissions = mapped
    }

    /**
     * @param argument Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
     */
    @JvmName("iurnoibwgvaunmcn")
    public suspend fun ec2InboundPermissions(vararg argument: suspend FleetEc2InboundPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FleetEc2InboundPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2InboundPermissions = mapped
    }

    /**
     * @param argument Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
     */
    @JvmName("gswcnggcjspnacse")
    public suspend fun ec2InboundPermissions(argument: suspend FleetEc2InboundPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FleetEc2InboundPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ec2InboundPermissions = mapped
    }

    /**
     * @param values Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
     */
    @JvmName("ohutexdkhcehvdtm")
    public suspend fun ec2InboundPermissions(vararg values: FleetEc2InboundPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ec2InboundPermissions = mapped
    }

    /**
     * @param value Name of an EC2 instance typeE.g., `t2.micro`
     */
    @JvmName("rlmhisntofaulewf")
    public suspend fun ec2InstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2InstanceType = mapped
    }

    /**
     * @param value Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
     */
    @JvmName("mgvesqsiaekmwmpy")
    public suspend fun fleetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetType = mapped
    }

    /**
     * @param value ARN of an IAM role that instances in the fleet can assume.
     */
    @JvmName("mqxxtxcfcuqgdhqf")
    public suspend fun instanceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceRoleArn = mapped
    }

    /**
     * @param value List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
     */
    @JvmName("flfjqxoncwginlmy")
    public suspend fun metricGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricGroups = mapped
    }

    /**
     * @param values List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
     */
    @JvmName("goaeugfmgavkboqs")
    public suspend fun metricGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricGroups = mapped
    }

    /**
     * @param value The name of the fleet.
     */
    @JvmName("nvotidrvewkrftqn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
     */
    @JvmName("mdpksvnxyhiawwyv")
    public suspend fun newGameSessionProtectionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newGameSessionProtectionPolicy = mapped
    }

    /**
     * @param value Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
     */
    @JvmName("jxisasyunrdecmej")
    public suspend fun resourceCreationLimitPolicy(`value`: FleetResourceCreationLimitPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceCreationLimitPolicy = mapped
    }

    /**
     * @param argument Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
     */
    @JvmName("hmtkbcvquvcnfeim")
    public suspend fun resourceCreationLimitPolicy(argument: suspend FleetResourceCreationLimitPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = FleetResourceCreationLimitPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.resourceCreationLimitPolicy = mapped
    }

    /**
     * @param value Instructions for launching server processes on each instance in the fleet. See below.
     */
    @JvmName("dpsotbqtdyxokclg")
    public suspend fun runtimeConfiguration(`value`: FleetRuntimeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeConfiguration = mapped
    }

    /**
     * @param argument Instructions for launching server processes on each instance in the fleet. See below.
     */
    @JvmName("uwkouarqksxejwvt")
    public suspend fun runtimeConfiguration(argument: suspend FleetRuntimeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FleetRuntimeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runtimeConfiguration = mapped
    }

    /**
     * @param value ID of the GameLift Script to be deployed on the fleet.
     */
    @JvmName("vvxoxthtgkmtssfw")
    public suspend fun scriptId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptId = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hlitwdjcxhfgppex")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kddndqsliwokfidg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FleetArgs = FleetArgs(
        buildId = buildId,
        certificateConfiguration = certificateConfiguration,
        description = description,
        ec2InboundPermissions = ec2InboundPermissions,
        ec2InstanceType = ec2InstanceType,
        fleetType = fleetType,
        instanceRoleArn = instanceRoleArn,
        metricGroups = metricGroups,
        name = name,
        newGameSessionProtectionPolicy = newGameSessionProtectionPolicy,
        resourceCreationLimitPolicy = resourceCreationLimitPolicy,
        runtimeConfiguration = runtimeConfiguration,
        scriptId = scriptId,
        tags = tags,
    )
}
