@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupAutoScalingPolicy
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupInstanceDefinition
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupLaunchTemplate
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupAutoScalingPolicy.Companion.toKotlin as gameServerGroupAutoScalingPolicyToKotlin
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupInstanceDefinition.Companion.toKotlin as gameServerGroupInstanceDefinitionToKotlin
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupLaunchTemplate.Companion.toKotlin as gameServerGroupLaunchTemplateToKotlin

/**
 * Builder for [GameServerGroup].
 */
@PulumiTagMarker
public class GameServerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GameServerGroupArgs = GameServerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GameServerGroupArgsBuilder.() -> Unit) {
        val builder = GameServerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GameServerGroup {
        val builtJavaResource = com.pulumi.aws.gamelift.GameServerGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GameServerGroup(builtJavaResource)
    }
}

/**
 * Provides an GameLift Game Server Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.gamelift.GameServerGroup("example", {
 *     gameServerGroupName: "example",
 *     instanceDefinitions: [
 *         {
 *             instanceType: "c5.large",
 *         },
 *         {
 *             instanceType: "c5a.large",
 *         },
 *     ],
 *     launchTemplate: {
 *         id: exampleAwsLaunchTemplate.id,
 *     },
 *     maxSize: 1,
 *     minSize: 1,
 *     roleArn: exampleAwsIamRole.arn,
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicyAttachment],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.gamelift.GameServerGroup("example",
 *     game_server_group_name="example",
 *     instance_definitions=[
 *         {
 *             "instance_type": "c5.large",
 *         },
 *         {
 *             "instance_type": "c5a.large",
 *         },
 *     ],
 *     launch_template={
 *         "id": example_aws_launch_template["id"],
 *     },
 *     max_size=1,
 *     min_size=1,
 *     role_arn=example_aws_iam_role["arn"],
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy_attachment]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GameLift.GameServerGroup("example", new()
 *     {
 *         GameServerGroupName = "example",
 *         InstanceDefinitions = new[]
 *         {
 *             new Aws.GameLift.Inputs.GameServerGroupInstanceDefinitionArgs
 *             {
 *                 InstanceType = "c5.large",
 *             },
 *             new Aws.GameLift.Inputs.GameServerGroupInstanceDefinitionArgs
 *             {
 *                 InstanceType = "c5a.large",
 *             },
 *         },
 *         LaunchTemplate = new Aws.GameLift.Inputs.GameServerGroupLaunchTemplateArgs
 *         {
 *             Id = exampleAwsLaunchTemplate.Id,
 *         },
 *         MaxSize = 1,
 *         MinSize = 1,
 *         RoleArn = exampleAwsIamRole.Arn,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicyAttachment,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewGameServerGroup(ctx, "example", &gamelift.GameServerGroupArgs{
 * 			GameServerGroupName: pulumi.String("example"),
 * 			InstanceDefinitions: gamelift.GameServerGroupInstanceDefinitionArray{
 * 				&gamelift.GameServerGroupInstanceDefinitionArgs{
 * 					InstanceType: pulumi.String("c5.large"),
 * 				},
 * 				&gamelift.GameServerGroupInstanceDefinitionArgs{
 * 					InstanceType: pulumi.String("c5a.large"),
 * 				},
 * 			},
 * 			LaunchTemplate: &gamelift.GameServerGroupLaunchTemplateArgs{
 * 				Id: pulumi.Any(exampleAwsLaunchTemplate.Id),
 * 			},
 * 			MaxSize: pulumi.Int(1),
 * 			MinSize: pulumi.Int(1),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicyAttachment,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameServerGroup;
 * import com.pulumi.aws.gamelift.GameServerGroupArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GameServerGroup("example", GameServerGroupArgs.builder()
 *             .gameServerGroupName("example")
 *             .instanceDefinitions(
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5.large")
 *                     .build(),
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5a.large")
 *                     .build())
 *             .launchTemplate(GameServerGroupLaunchTemplateArgs.builder()
 *                 .id(exampleAwsLaunchTemplate.id())
 *                 .build())
 *             .maxSize(1)
 *             .minSize(1)
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:gamelift:GameServerGroup
 *     properties:
 *       gameServerGroupName: example
 *       instanceDefinitions:
 *         - instanceType: c5.large
 *         - instanceType: c5a.large
 *       launchTemplate:
 *         id: ${exampleAwsLaunchTemplate.id}
 *       maxSize: 1
 *       minSize: 1
 *       roleArn: ${exampleAwsIamRole.arn}
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicyAttachment}
 * ```
 * <!--End PulumiCodeChooser -->
 * Full usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.gamelift.GameServerGroup("example", {
 *     autoScalingPolicy: {
 *         estimatedInstanceWarmup: 60,
 *         targetTrackingConfiguration: {
 *             targetValue: 75,
 *         },
 *     },
 *     balancingStrategy: "SPOT_ONLY",
 *     gameServerGroupName: "example",
 *     gameServerProtectionPolicy: "FULL_PROTECTION",
 *     instanceDefinitions: [
 *         {
 *             instanceType: "c5.large",
 *             weightedCapacity: "1",
 *         },
 *         {
 *             instanceType: "c5.2xlarge",
 *             weightedCapacity: "2",
 *         },
 *     ],
 *     launchTemplate: {
 *         id: exampleAwsLaunchTemplate.id,
 *         version: "1",
 *     },
 *     maxSize: 1,
 *     minSize: 1,
 *     roleArn: exampleAwsIamRole.arn,
 *     tags: {
 *         Name: "example",
 *     },
 *     vpcSubnets: [
 *         "subnet-12345678",
 *         "subnet-23456789",
 *     ],
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicyAttachment],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.gamelift.GameServerGroup("example",
 *     auto_scaling_policy={
 *         "estimated_instance_warmup": 60,
 *         "target_tracking_configuration": {
 *             "target_value": 75,
 *         },
 *     },
 *     balancing_strategy="SPOT_ONLY",
 *     game_server_group_name="example",
 *     game_server_protection_policy="FULL_PROTECTION",
 *     instance_definitions=[
 *         {
 *             "instance_type": "c5.large",
 *             "weighted_capacity": "1",
 *         },
 *         {
 *             "instance_type": "c5.2xlarge",
 *             "weighted_capacity": "2",
 *         },
 *     ],
 *     launch_template={
 *         "id": example_aws_launch_template["id"],
 *         "version": "1",
 *     },
 *     max_size=1,
 *     min_size=1,
 *     role_arn=example_aws_iam_role["arn"],
 *     tags={
 *         "Name": "example",
 *     },
 *     vpc_subnets=[
 *         "subnet-12345678",
 *         "subnet-23456789",
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy_attachment]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GameLift.GameServerGroup("example", new()
 *     {
 *         AutoScalingPolicy = new Aws.GameLift.Inputs.GameServerGroupAutoScalingPolicyArgs
 *         {
 *             EstimatedInstanceWarmup = 60,
 *             TargetTrackingConfiguration = new Aws.GameLift.Inputs.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs
 *             {
 *                 TargetValue = 75,
 *             },
 *         },
 *         BalancingStrategy = "SPOT_ONLY",
 *         GameServerGroupName = "example",
 *         GameServerProtectionPolicy = "FULL_PROTECTION",
 *         InstanceDefinitions = new[]
 *         {
 *             new Aws.GameLift.Inputs.GameServerGroupInstanceDefinitionArgs
 *             {
 *                 InstanceType = "c5.large",
 *                 WeightedCapacity = "1",
 *             },
 *             new Aws.GameLift.Inputs.GameServerGroupInstanceDefinitionArgs
 *             {
 *                 InstanceType = "c5.2xlarge",
 *                 WeightedCapacity = "2",
 *             },
 *         },
 *         LaunchTemplate = new Aws.GameLift.Inputs.GameServerGroupLaunchTemplateArgs
 *         {
 *             Id = exampleAwsLaunchTemplate.Id,
 *             Version = "1",
 *         },
 *         MaxSize = 1,
 *         MinSize = 1,
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *         VpcSubnets = new[]
 *         {
 *             "subnet-12345678",
 *             "subnet-23456789",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicyAttachment,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewGameServerGroup(ctx, "example", &gamelift.GameServerGroupArgs{
 * 			AutoScalingPolicy: &gamelift.GameServerGroupAutoScalingPolicyArgs{
 * 				EstimatedInstanceWarmup: pulumi.Int(60),
 * 				TargetTrackingConfiguration: &gamelift.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs{
 * 					TargetValue: pulumi.Float64(75),
 * 				},
 * 			},
 * 			BalancingStrategy:          pulumi.String("SPOT_ONLY"),
 * 			GameServerGroupName:        pulumi.String("example"),
 * 			GameServerProtectionPolicy: pulumi.String("FULL_PROTECTION"),
 * 			InstanceDefinitions: gamelift.GameServerGroupInstanceDefinitionArray{
 * 				&gamelift.GameServerGroupInstanceDefinitionArgs{
 * 					InstanceType:     pulumi.String("c5.large"),
 * 					WeightedCapacity: pulumi.String("1"),
 * 				},
 * 				&gamelift.GameServerGroupInstanceDefinitionArgs{
 * 					InstanceType:     pulumi.String("c5.2xlarge"),
 * 					WeightedCapacity: pulumi.String("2"),
 * 				},
 * 			},
 * 			LaunchTemplate: &gamelift.GameServerGroupLaunchTemplateArgs{
 * 				Id:      pulumi.Any(exampleAwsLaunchTemplate.Id),
 * 				Version: pulumi.String("1"),
 * 			},
 * 			MaxSize: pulumi.Int(1),
 * 			MinSize: pulumi.Int(1),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 			VpcSubnets: pulumi.StringArray{
 * 				pulumi.String("subnet-12345678"),
 * 				pulumi.String("subnet-23456789"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicyAttachment,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameServerGroup;
 * import com.pulumi.aws.gamelift.GameServerGroupArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GameServerGroup("example", GameServerGroupArgs.builder()
 *             .autoScalingPolicy(GameServerGroupAutoScalingPolicyArgs.builder()
 *                 .estimatedInstanceWarmup(60)
 *                 .targetTrackingConfiguration(GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs.builder()
 *                     .targetValue(75)
 *                     .build())
 *                 .build())
 *             .balancingStrategy("SPOT_ONLY")
 *             .gameServerGroupName("example")
 *             .gameServerProtectionPolicy("FULL_PROTECTION")
 *             .instanceDefinitions(
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5.large")
 *                     .weightedCapacity("1")
 *                     .build(),
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5.2xlarge")
 *                     .weightedCapacity("2")
 *                     .build())
 *             .launchTemplate(GameServerGroupLaunchTemplateArgs.builder()
 *                 .id(exampleAwsLaunchTemplate.id())
 *                 .version("1")
 *                 .build())
 *             .maxSize(1)
 *             .minSize(1)
 *             .roleArn(exampleAwsIamRole.arn())
 *             .tags(Map.of("Name", "example"))
 *             .vpcSubnets(
 *                 "subnet-12345678",
 *                 "subnet-23456789")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:gamelift:GameServerGroup
 *     properties:
 *       autoScalingPolicy:
 *         estimatedInstanceWarmup: 60
 *         targetTrackingConfiguration:
 *           targetValue: 75
 *       balancingStrategy: SPOT_ONLY
 *       gameServerGroupName: example
 *       gameServerProtectionPolicy: FULL_PROTECTION
 *       instanceDefinitions:
 *         - instanceType: c5.large
 *           weightedCapacity: '1'
 *         - instanceType: c5.2xlarge
 *           weightedCapacity: '2'
 *       launchTemplate:
 *         id: ${exampleAwsLaunchTemplate.id}
 *         version: '1'
 *       maxSize: 1
 *       minSize: 1
 *       roleArn: ${exampleAwsIamRole.arn}
 *       tags:
 *         Name: example
 *       vpcSubnets:
 *         - subnet-12345678
 *         - subnet-23456789
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicyAttachment}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example IAM Role for GameLift Game Server Group
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getPartition({});
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: [
 *                 "autoscaling.amazonaws.com",
 *                 "gamelift.amazonaws.com",
 *             ],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const example = new aws.iam.Role("example", {
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 *     name: "gamelift-game-server-group-example",
 * });
 * const exampleRolePolicyAttachment = new aws.iam.RolePolicyAttachment("example", {
 *     policyArn: current.then(current => `arn:${current.partition}:iam::aws:policy/GameLiftGameServerGroupPolicy`),
 *     role: example.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_partition()
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": [
 *             "autoscaling.amazonaws.com",
 *             "gamelift.amazonaws.com",
 *         ],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example = aws.iam.Role("example",
 *     assume_role_policy=assume_role.json,
 *     name="gamelift-game-server-group-example")
 * example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
 *     policy_arn=f"arn:{current.partition}:iam::aws:policy/GameLiftGameServerGroupPolicy",
 *     role=example.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetPartition.Invoke();
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "autoscaling.amazonaws.com",
 *                             "gamelift.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         Name = "gamelift-game-server-group-example",
 *     });
 *     var exampleRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("example", new()
 *     {
 *         PolicyArn = $"arn:{current.Apply(getPartitionResult => getPartitionResult.Partition)}:iam::aws:policy/GameLiftGameServerGroupPolicy",
 *         Role = example.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetPartition(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"autoscaling.amazonaws.com",
 * 								"gamelift.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 			Name:             pulumi.String("gamelift-game-server-group-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.Sprintf("arn:%v:iam::aws:policy/GameLiftGameServerGroupPolicy", current.Partition),
 * 			Role:      example.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getPartition();
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers(
 *                         "autoscaling.amazonaws.com",
 *                         "gamelift.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .name("gamelift-game-server-group-example")
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn(String.format("arn:%s:iam::aws:policy/GameLiftGameServerGroupPolicy", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${assumeRole.json}
 *       name: gamelift-game-server-group-example
 *   exampleRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: example
 *     properties:
 *       policyArn: arn:${current.partition}:iam::aws:policy/GameLiftGameServerGroupPolicy
 *       role: ${example.name}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - autoscaling.amazonaws.com
 *                   - gamelift.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Game Server Group using the `name`. For example:
 * ```sh
 * $ pulumi import aws:gamelift/gameServerGroup:GameServerGroup example example
 * ```
 */
public class GameServerGroup internal constructor(
    override val javaResource: com.pulumi.aws.gamelift.GameServerGroup,
) : KotlinCustomResource(javaResource, GameServerGroupMapper) {
    /**
     * The ARN of the GameLift Game Server Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the created EC2 Auto Scaling group.
     */
    public val autoScalingGroupArn: Output<String>
        get() = javaResource.autoScalingGroupArn().applyValue({ args0 -> args0 })

    public val autoScalingPolicy: Output<GameServerGroupAutoScalingPolicy>?
        get() = javaResource.autoScalingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gameServerGroupAutoScalingPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
     * Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
     */
    public val balancingStrategy: Output<String>
        get() = javaResource.balancingStrategy().applyValue({ args0 -> args0 })

    /**
     * Name of the game server group.
     * This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
     */
    public val gameServerGroupName: Output<String>
        get() = javaResource.gameServerGroupName().applyValue({ args0 -> args0 })

    /**
     * Indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game.
     * Protected instances cannot be terminated while there are active game servers running except in the event
     * of a forced game server group deletion.
     * Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
     */
    public val gameServerProtectionPolicy: Output<String>
        get() = javaResource.gameServerProtectionPolicy().applyValue({ args0 -> args0 })

    public val instanceDefinitions: Output<List<GameServerGroupInstanceDefinition>>
        get() = javaResource.instanceDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gameServerGroupInstanceDefinitionToKotlin(args0) })
            })
        })

    public val launchTemplate: Output<GameServerGroupLaunchTemplate>
        get() = javaResource.launchTemplate().applyValue({ args0 ->
            args0.let({ args0 ->
                gameServerGroupLaunchTemplateToKotlin(args0)
            })
        })

    /**
     * The maximum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
     */
    public val maxSize: Output<Int>
        get() = javaResource.maxSize().applyValue({ args0 -> args0 })

    /**
     * The minimum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
     */
    public val minSize: Output<Int>
        get() = javaResource.minSize().applyValue({ args0 -> args0 })

    /**
     * ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    public val vpcSubnets: Output<List<String>>?
        get() = javaResource.vpcSubnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object GameServerGroupMapper : ResourceMapper<GameServerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.gamelift.GameServerGroup::class == javaResource::class

    override fun map(javaResource: Resource): GameServerGroup = GameServerGroup(
        javaResource as
            com.pulumi.aws.gamelift.GameServerGroup,
    )
}

/**
 * @see [GameServerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GameServerGroup].
 */
public suspend fun gameServerGroup(
    name: String,
    block: suspend GameServerGroupResourceBuilder.() -> Unit,
): GameServerGroup {
    val builder = GameServerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GameServerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gameServerGroup(name: String): GameServerGroup {
    val builder = GameServerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
