@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.GameServerGroupArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupAutoScalingPolicyArgs
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupAutoScalingPolicyArgsBuilder
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupInstanceDefinitionArgs
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupInstanceDefinitionArgsBuilder
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupLaunchTemplateArgs
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupLaunchTemplateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an GameLift Game Server Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.gamelift.GameServerGroup("example", {
 *     gameServerGroupName: "example",
 *     instanceDefinitions: [
 *         {
 *             instanceType: "c5.large",
 *         },
 *         {
 *             instanceType: "c5a.large",
 *         },
 *     ],
 *     launchTemplate: {
 *         id: exampleAwsLaunchTemplate.id,
 *     },
 *     maxSize: 1,
 *     minSize: 1,
 *     roleArn: exampleAwsIamRole.arn,
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicyAttachment],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.gamelift.GameServerGroup("example",
 *     game_server_group_name="example",
 *     instance_definitions=[
 *         {
 *             "instance_type": "c5.large",
 *         },
 *         {
 *             "instance_type": "c5a.large",
 *         },
 *     ],
 *     launch_template={
 *         "id": example_aws_launch_template["id"],
 *     },
 *     max_size=1,
 *     min_size=1,
 *     role_arn=example_aws_iam_role["arn"],
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy_attachment]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GameLift.GameServerGroup("example", new()
 *     {
 *         GameServerGroupName = "example",
 *         InstanceDefinitions = new[]
 *         {
 *             new Aws.GameLift.Inputs.GameServerGroupInstanceDefinitionArgs
 *             {
 *                 InstanceType = "c5.large",
 *             },
 *             new Aws.GameLift.Inputs.GameServerGroupInstanceDefinitionArgs
 *             {
 *                 InstanceType = "c5a.large",
 *             },
 *         },
 *         LaunchTemplate = new Aws.GameLift.Inputs.GameServerGroupLaunchTemplateArgs
 *         {
 *             Id = exampleAwsLaunchTemplate.Id,
 *         },
 *         MaxSize = 1,
 *         MinSize = 1,
 *         RoleArn = exampleAwsIamRole.Arn,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicyAttachment,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewGameServerGroup(ctx, "example", &gamelift.GameServerGroupArgs{
 * 			GameServerGroupName: pulumi.String("example"),
 * 			InstanceDefinitions: gamelift.GameServerGroupInstanceDefinitionArray{
 * 				&gamelift.GameServerGroupInstanceDefinitionArgs{
 * 					InstanceType: pulumi.String("c5.large"),
 * 				},
 * 				&gamelift.GameServerGroupInstanceDefinitionArgs{
 * 					InstanceType: pulumi.String("c5a.large"),
 * 				},
 * 			},
 * 			LaunchTemplate: &gamelift.GameServerGroupLaunchTemplateArgs{
 * 				Id: pulumi.Any(exampleAwsLaunchTemplate.Id),
 * 			},
 * 			MaxSize: pulumi.Int(1),
 * 			MinSize: pulumi.Int(1),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicyAttachment,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameServerGroup;
 * import com.pulumi.aws.gamelift.GameServerGroupArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GameServerGroup("example", GameServerGroupArgs.builder()
 *             .gameServerGroupName("example")
 *             .instanceDefinitions(
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5.large")
 *                     .build(),
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5a.large")
 *                     .build())
 *             .launchTemplate(GameServerGroupLaunchTemplateArgs.builder()
 *                 .id(exampleAwsLaunchTemplate.id())
 *                 .build())
 *             .maxSize(1)
 *             .minSize(1)
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:gamelift:GameServerGroup
 *     properties:
 *       gameServerGroupName: example
 *       instanceDefinitions:
 *         - instanceType: c5.large
 *         - instanceType: c5a.large
 *       launchTemplate:
 *         id: ${exampleAwsLaunchTemplate.id}
 *       maxSize: 1
 *       minSize: 1
 *       roleArn: ${exampleAwsIamRole.arn}
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicyAttachment}
 * ```
 * <!--End PulumiCodeChooser -->
 * Full usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.gamelift.GameServerGroup("example", {
 *     autoScalingPolicy: {
 *         estimatedInstanceWarmup: 60,
 *         targetTrackingConfiguration: {
 *             targetValue: 75,
 *         },
 *     },
 *     balancingStrategy: "SPOT_ONLY",
 *     gameServerGroupName: "example",
 *     gameServerProtectionPolicy: "FULL_PROTECTION",
 *     instanceDefinitions: [
 *         {
 *             instanceType: "c5.large",
 *             weightedCapacity: "1",
 *         },
 *         {
 *             instanceType: "c5.2xlarge",
 *             weightedCapacity: "2",
 *         },
 *     ],
 *     launchTemplate: {
 *         id: exampleAwsLaunchTemplate.id,
 *         version: "1",
 *     },
 *     maxSize: 1,
 *     minSize: 1,
 *     roleArn: exampleAwsIamRole.arn,
 *     tags: {
 *         Name: "example",
 *     },
 *     vpcSubnets: [
 *         "subnet-12345678",
 *         "subnet-23456789",
 *     ],
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicyAttachment],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.gamelift.GameServerGroup("example",
 *     auto_scaling_policy={
 *         "estimated_instance_warmup": 60,
 *         "target_tracking_configuration": {
 *             "target_value": 75,
 *         },
 *     },
 *     balancing_strategy="SPOT_ONLY",
 *     game_server_group_name="example",
 *     game_server_protection_policy="FULL_PROTECTION",
 *     instance_definitions=[
 *         {
 *             "instance_type": "c5.large",
 *             "weighted_capacity": "1",
 *         },
 *         {
 *             "instance_type": "c5.2xlarge",
 *             "weighted_capacity": "2",
 *         },
 *     ],
 *     launch_template={
 *         "id": example_aws_launch_template["id"],
 *         "version": "1",
 *     },
 *     max_size=1,
 *     min_size=1,
 *     role_arn=example_aws_iam_role["arn"],
 *     tags={
 *         "Name": "example",
 *     },
 *     vpc_subnets=[
 *         "subnet-12345678",
 *         "subnet-23456789",
 *     ],
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy_attachment]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GameLift.GameServerGroup("example", new()
 *     {
 *         AutoScalingPolicy = new Aws.GameLift.Inputs.GameServerGroupAutoScalingPolicyArgs
 *         {
 *             EstimatedInstanceWarmup = 60,
 *             TargetTrackingConfiguration = new Aws.GameLift.Inputs.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs
 *             {
 *                 TargetValue = 75,
 *             },
 *         },
 *         BalancingStrategy = "SPOT_ONLY",
 *         GameServerGroupName = "example",
 *         GameServerProtectionPolicy = "FULL_PROTECTION",
 *         InstanceDefinitions = new[]
 *         {
 *             new Aws.GameLift.Inputs.GameServerGroupInstanceDefinitionArgs
 *             {
 *                 InstanceType = "c5.large",
 *                 WeightedCapacity = "1",
 *             },
 *             new Aws.GameLift.Inputs.GameServerGroupInstanceDefinitionArgs
 *             {
 *                 InstanceType = "c5.2xlarge",
 *                 WeightedCapacity = "2",
 *             },
 *         },
 *         LaunchTemplate = new Aws.GameLift.Inputs.GameServerGroupLaunchTemplateArgs
 *         {
 *             Id = exampleAwsLaunchTemplate.Id,
 *             Version = "1",
 *         },
 *         MaxSize = 1,
 *         MinSize = 1,
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *         VpcSubnets = new[]
 *         {
 *             "subnet-12345678",
 *             "subnet-23456789",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicyAttachment,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewGameServerGroup(ctx, "example", &gamelift.GameServerGroupArgs{
 * 			AutoScalingPolicy: &gamelift.GameServerGroupAutoScalingPolicyArgs{
 * 				EstimatedInstanceWarmup: pulumi.Int(60),
 * 				TargetTrackingConfiguration: &gamelift.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs{
 * 					TargetValue: pulumi.Float64(75),
 * 				},
 * 			},
 * 			BalancingStrategy:          pulumi.String("SPOT_ONLY"),
 * 			GameServerGroupName:        pulumi.String("example"),
 * 			GameServerProtectionPolicy: pulumi.String("FULL_PROTECTION"),
 * 			InstanceDefinitions: gamelift.GameServerGroupInstanceDefinitionArray{
 * 				&gamelift.GameServerGroupInstanceDefinitionArgs{
 * 					InstanceType:     pulumi.String("c5.large"),
 * 					WeightedCapacity: pulumi.String("1"),
 * 				},
 * 				&gamelift.GameServerGroupInstanceDefinitionArgs{
 * 					InstanceType:     pulumi.String("c5.2xlarge"),
 * 					WeightedCapacity: pulumi.String("2"),
 * 				},
 * 			},
 * 			LaunchTemplate: &gamelift.GameServerGroupLaunchTemplateArgs{
 * 				Id:      pulumi.Any(exampleAwsLaunchTemplate.Id),
 * 				Version: pulumi.String("1"),
 * 			},
 * 			MaxSize: pulumi.Int(1),
 * 			MinSize: pulumi.Int(1),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 			VpcSubnets: pulumi.StringArray{
 * 				pulumi.String("subnet-12345678"),
 * 				pulumi.String("subnet-23456789"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicyAttachment,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameServerGroup;
 * import com.pulumi.aws.gamelift.GameServerGroupArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GameServerGroup("example", GameServerGroupArgs.builder()
 *             .autoScalingPolicy(GameServerGroupAutoScalingPolicyArgs.builder()
 *                 .estimatedInstanceWarmup(60)
 *                 .targetTrackingConfiguration(GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs.builder()
 *                     .targetValue(75)
 *                     .build())
 *                 .build())
 *             .balancingStrategy("SPOT_ONLY")
 *             .gameServerGroupName("example")
 *             .gameServerProtectionPolicy("FULL_PROTECTION")
 *             .instanceDefinitions(
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5.large")
 *                     .weightedCapacity("1")
 *                     .build(),
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5.2xlarge")
 *                     .weightedCapacity("2")
 *                     .build())
 *             .launchTemplate(GameServerGroupLaunchTemplateArgs.builder()
 *                 .id(exampleAwsLaunchTemplate.id())
 *                 .version("1")
 *                 .build())
 *             .maxSize(1)
 *             .minSize(1)
 *             .roleArn(exampleAwsIamRole.arn())
 *             .tags(Map.of("Name", "example"))
 *             .vpcSubnets(
 *                 "subnet-12345678",
 *                 "subnet-23456789")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:gamelift:GameServerGroup
 *     properties:
 *       autoScalingPolicy:
 *         estimatedInstanceWarmup: 60
 *         targetTrackingConfiguration:
 *           targetValue: 75
 *       balancingStrategy: SPOT_ONLY
 *       gameServerGroupName: example
 *       gameServerProtectionPolicy: FULL_PROTECTION
 *       instanceDefinitions:
 *         - instanceType: c5.large
 *           weightedCapacity: '1'
 *         - instanceType: c5.2xlarge
 *           weightedCapacity: '2'
 *       launchTemplate:
 *         id: ${exampleAwsLaunchTemplate.id}
 *         version: '1'
 *       maxSize: 1
 *       minSize: 1
 *       roleArn: ${exampleAwsIamRole.arn}
 *       tags:
 *         Name: example
 *       vpcSubnets:
 *         - subnet-12345678
 *         - subnet-23456789
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicyAttachment}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example IAM Role for GameLift Game Server Group
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getPartition({});
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: [
 *                 "autoscaling.amazonaws.com",
 *                 "gamelift.amazonaws.com",
 *             ],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const example = new aws.iam.Role("example", {
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 *     name: "gamelift-game-server-group-example",
 * });
 * const exampleRolePolicyAttachment = new aws.iam.RolePolicyAttachment("example", {
 *     policyArn: current.then(current => `arn:${current.partition}:iam::aws:policy/GameLiftGameServerGroupPolicy`),
 *     role: example.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_partition()
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": [
 *             "autoscaling.amazonaws.com",
 *             "gamelift.amazonaws.com",
 *         ],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example = aws.iam.Role("example",
 *     assume_role_policy=assume_role.json,
 *     name="gamelift-game-server-group-example")
 * example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
 *     policy_arn=f"arn:{current.partition}:iam::aws:policy/GameLiftGameServerGroupPolicy",
 *     role=example.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetPartition.Invoke();
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "autoscaling.amazonaws.com",
 *                             "gamelift.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         Name = "gamelift-game-server-group-example",
 *     });
 *     var exampleRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("example", new()
 *     {
 *         PolicyArn = $"arn:{current.Apply(getPartitionResult => getPartitionResult.Partition)}:iam::aws:policy/GameLiftGameServerGroupPolicy",
 *         Role = example.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetPartition(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"autoscaling.amazonaws.com",
 * 								"gamelift.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 			Name:             pulumi.String("gamelift-game-server-group-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.Sprintf("arn:%v:iam::aws:policy/GameLiftGameServerGroupPolicy", current.Partition),
 * 			Role:      example.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getPartition();
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers(
 *                         "autoscaling.amazonaws.com",
 *                         "gamelift.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .name("gamelift-game-server-group-example")
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn(String.format("arn:%s:iam::aws:policy/GameLiftGameServerGroupPolicy", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       assumeRolePolicy: ${assumeRole.json}
 *       name: gamelift-game-server-group-example
 *   exampleRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: example
 *     properties:
 *       policyArn: arn:${current.partition}:iam::aws:policy/GameLiftGameServerGroupPolicy
 *       role: ${example.name}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getPartition
 *       Arguments: {}
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - autoscaling.amazonaws.com
 *                   - gamelift.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Game Server Group using the `name`. For example:
 * ```sh
 * $ pulumi import aws:gamelift/gameServerGroup:GameServerGroup example example
 * ```
 * @property autoScalingPolicy
 * @property balancingStrategy Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
 * Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
 * @property gameServerGroupName Name of the game server group.
 * This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
 * @property gameServerProtectionPolicy Indicates whether instances in the game server group are protected from early termination.
 * Unprotected instances that have active game servers running might be terminated during a scale-down event,
 * causing players to be dropped from the game.
 * Protected instances cannot be terminated while there are active game servers running except in the event
 * of a forced game server group deletion.
 * Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
 * @property instanceDefinitions
 * @property launchTemplate
 * @property maxSize The maximum number of instances allowed in the EC2 Auto Scaling group.
 * During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
 * @property minSize The minimum number of instances allowed in the EC2 Auto Scaling group.
 * During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
 * @property roleArn ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
 * @property tags Key-value map of resource tags
 * @property vpcSubnets A list of VPC subnets to use with instances in the game server group.
 * By default, all GameLift FleetIQ-supported Availability Zones are used.
 */
public data class GameServerGroupArgs(
    public val autoScalingPolicy: Output<GameServerGroupAutoScalingPolicyArgs>? = null,
    public val balancingStrategy: Output<String>? = null,
    public val gameServerGroupName: Output<String>? = null,
    public val gameServerProtectionPolicy: Output<String>? = null,
    public val instanceDefinitions: Output<List<GameServerGroupInstanceDefinitionArgs>>? = null,
    public val launchTemplate: Output<GameServerGroupLaunchTemplateArgs>? = null,
    public val maxSize: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSubnets: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.GameServerGroupArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.GameServerGroupArgs =
        com.pulumi.aws.gamelift.GameServerGroupArgs.builder()
            .autoScalingPolicy(autoScalingPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .balancingStrategy(balancingStrategy?.applyValue({ args0 -> args0 }))
            .gameServerGroupName(gameServerGroupName?.applyValue({ args0 -> args0 }))
            .gameServerProtectionPolicy(gameServerProtectionPolicy?.applyValue({ args0 -> args0 }))
            .instanceDefinitions(
                instanceDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchTemplate(launchTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcSubnets(vpcSubnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GameServerGroupArgs].
 */
@PulumiTagMarker
public class GameServerGroupArgsBuilder internal constructor() {
    private var autoScalingPolicy: Output<GameServerGroupAutoScalingPolicyArgs>? = null

    private var balancingStrategy: Output<String>? = null

    private var gameServerGroupName: Output<String>? = null

    private var gameServerProtectionPolicy: Output<String>? = null

    private var instanceDefinitions: Output<List<GameServerGroupInstanceDefinitionArgs>>? = null

    private var launchTemplate: Output<GameServerGroupLaunchTemplateArgs>? = null

    private var maxSize: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSubnets: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ntvotgjvaydpjfwd")
    public suspend fun autoScalingPolicy(`value`: Output<GameServerGroupAutoScalingPolicyArgs>) {
        this.autoScalingPolicy = value
    }

    /**
     * @param value Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
     * Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
     */
    @JvmName("fpoekrawvyrdtoov")
    public suspend fun balancingStrategy(`value`: Output<String>) {
        this.balancingStrategy = value
    }

    /**
     * @param value Name of the game server group.
     * This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
     */
    @JvmName("anukceaatjfjfqfx")
    public suspend fun gameServerGroupName(`value`: Output<String>) {
        this.gameServerGroupName = value
    }

    /**
     * @param value Indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game.
     * Protected instances cannot be terminated while there are active game servers running except in the event
     * of a forced game server group deletion.
     * Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
     */
    @JvmName("jiqqqiowmbndnwhx")
    public suspend fun gameServerProtectionPolicy(`value`: Output<String>) {
        this.gameServerProtectionPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("gboravxucgxplviy")
    public suspend fun instanceDefinitions(`value`: Output<List<GameServerGroupInstanceDefinitionArgs>>) {
        this.instanceDefinitions = value
    }

    @JvmName("svsdovgnnlruhoth")
    public suspend fun instanceDefinitions(vararg values: Output<GameServerGroupInstanceDefinitionArgs>) {
        this.instanceDefinitions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fccigijwivxuiyym")
    public suspend fun instanceDefinitions(values: List<Output<GameServerGroupInstanceDefinitionArgs>>) {
        this.instanceDefinitions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wfdbicybuvtidctu")
    public suspend fun launchTemplate(`value`: Output<GameServerGroupLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value The maximum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
     */
    @JvmName("hepkyekjujpmahae")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value The minimum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
     */
    @JvmName("wljrfvfkpmwquwgb")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    @JvmName("manbskelychunlhy")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Key-value map of resource tags
     */
    @JvmName("nssbkgdovrhnsuaf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    @JvmName("jluxtyemklvigfph")
    public suspend fun vpcSubnets(`value`: Output<List<String>>) {
        this.vpcSubnets = value
    }

    @JvmName("bvynfycmmngoyono")
    public suspend fun vpcSubnets(vararg values: Output<String>) {
        this.vpcSubnets = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    @JvmName("feawriuupxnwsnpk")
    public suspend fun vpcSubnets(values: List<Output<String>>) {
        this.vpcSubnets = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("chhysyiwcddmvxao")
    public suspend fun autoScalingPolicy(`value`: GameServerGroupAutoScalingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingPolicy = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gaeeekgsmkhfwonw")
    public suspend fun autoScalingPolicy(argument: suspend GameServerGroupAutoScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = GameServerGroupAutoScalingPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoScalingPolicy = mapped
    }

    /**
     * @param value Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
     * Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
     */
    @JvmName("ulybedacpldpauyc")
    public suspend fun balancingStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.balancingStrategy = mapped
    }

    /**
     * @param value Name of the game server group.
     * This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
     */
    @JvmName("vslqgdsjorvqytal")
    public suspend fun gameServerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gameServerGroupName = mapped
    }

    /**
     * @param value Indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game.
     * Protected instances cannot be terminated while there are active game servers running except in the event
     * of a forced game server group deletion.
     * Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
     */
    @JvmName("nhvkxgsfmjwqxoiq")
    public suspend fun gameServerProtectionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gameServerProtectionPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("qtcefqrhdjtuuame")
    public suspend fun instanceDefinitions(`value`: List<GameServerGroupInstanceDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceDefinitions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yrodgsntfnjhnsti")
    public suspend fun instanceDefinitions(argument: List<suspend GameServerGroupInstanceDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GameServerGroupInstanceDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceDefinitions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gaikwwqsnmxjlpfo")
    public suspend fun instanceDefinitions(vararg argument: suspend GameServerGroupInstanceDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GameServerGroupInstanceDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceDefinitions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("awijyboaquxernjt")
    public suspend fun instanceDefinitions(argument: suspend GameServerGroupInstanceDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GameServerGroupInstanceDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instanceDefinitions = mapped
    }

    /**
     * @param values
     */
    @JvmName("eidqhpuionkfryvb")
    public suspend fun instanceDefinitions(vararg values: GameServerGroupInstanceDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceDefinitions = mapped
    }

    /**
     * @param value
     */
    @JvmName("cmmcssjblieqnxxg")
    public suspend fun launchTemplate(`value`: GameServerGroupLaunchTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vlrcmytauqpafwfk")
    public suspend fun launchTemplate(argument: suspend GameServerGroupLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = GameServerGroupLaunchTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    /**
     * @param value The maximum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
     */
    @JvmName("dgpysvbbktnfdhfk")
    public suspend fun maxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value The minimum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
     */
    @JvmName("gwcuhyxhrdruwvgt")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    @JvmName("qvbmeclnehaxtegn")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Key-value map of resource tags
     */
    @JvmName("inklhtwfenqkoosl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags
     */
    @JvmName("ahckfofcagjtmrow")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    @JvmName("ateptisqfcmwgkdj")
    public suspend fun vpcSubnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSubnets = mapped
    }

    /**
     * @param values A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    @JvmName("cpgbjigworclspik")
    public suspend fun vpcSubnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSubnets = mapped
    }

    internal fun build(): GameServerGroupArgs = GameServerGroupArgs(
        autoScalingPolicy = autoScalingPolicy,
        balancingStrategy = balancingStrategy,
        gameServerGroupName = gameServerGroupName,
        gameServerProtectionPolicy = gameServerProtectionPolicy,
        instanceDefinitions = instanceDefinitions,
        launchTemplate = launchTemplate,
        maxSize = maxSize,
        minSize = minSize,
        roleArn = roleArn,
        tags = tags,
        vpcSubnets = vpcSubnets,
    )
}
