@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.kotlin.outputs.GameSessionQueuePlayerLatencyPolicy
import com.pulumi.aws.gamelift.kotlin.outputs.GameSessionQueuePlayerLatencyPolicy.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [GameSessionQueue].
 */
@PulumiTagMarker
public class GameSessionQueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GameSessionQueueArgs = GameSessionQueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GameSessionQueueArgsBuilder.() -> Unit) {
        val builder = GameSessionQueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GameSessionQueue {
        val builtJavaResource = com.pulumi.aws.gamelift.GameSessionQueue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GameSessionQueue(builtJavaResource)
    }
}

/**
 * Provides an GameLift Game Session Queue resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.gamelift.GameSessionQueue("test", {
 *     name: "example-session-queue",
 *     destinations: [
 *         usWest2Fleet.arn,
 *         euCentral1Fleet.arn,
 *     ],
 *     notificationTarget: gameSessionQueueNotifications.arn,
 *     playerLatencyPolicies: [
 *         {
 *             maximumIndividualPlayerLatencyMilliseconds: 100,
 *             policyDurationSeconds: 5,
 *         },
 *         {
 *             maximumIndividualPlayerLatencyMilliseconds: 200,
 *         },
 *     ],
 *     timeoutInSeconds: 60,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.gamelift.GameSessionQueue("test",
 *     name="example-session-queue",
 *     destinations=[
 *         us_west2_fleet["arn"],
 *         eu_central1_fleet["arn"],
 *     ],
 *     notification_target=game_session_queue_notifications["arn"],
 *     player_latency_policies=[
 *         {
 *             "maximum_individual_player_latency_milliseconds": 100,
 *             "policy_duration_seconds": 5,
 *         },
 *         {
 *             "maximum_individual_player_latency_milliseconds": 200,
 *         },
 *     ],
 *     timeout_in_seconds=60)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.GameLift.GameSessionQueue("test", new()
 *     {
 *         Name = "example-session-queue",
 *         Destinations = new[]
 *         {
 *             usWest2Fleet.Arn,
 *             euCentral1Fleet.Arn,
 *         },
 *         NotificationTarget = gameSessionQueueNotifications.Arn,
 *         PlayerLatencyPolicies = new[]
 *         {
 *             new Aws.GameLift.Inputs.GameSessionQueuePlayerLatencyPolicyArgs
 *             {
 *                 MaximumIndividualPlayerLatencyMilliseconds = 100,
 *                 PolicyDurationSeconds = 5,
 *             },
 *             new Aws.GameLift.Inputs.GameSessionQueuePlayerLatencyPolicyArgs
 *             {
 *                 MaximumIndividualPlayerLatencyMilliseconds = 200,
 *             },
 *         },
 *         TimeoutInSeconds = 60,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewGameSessionQueue(ctx, "test", &gamelift.GameSessionQueueArgs{
 * 			Name: pulumi.String("example-session-queue"),
 * 			Destinations: pulumi.StringArray{
 * 				usWest2Fleet.Arn,
 * 				euCentral1Fleet.Arn,
 * 			},
 * 			NotificationTarget: pulumi.Any(gameSessionQueueNotifications.Arn),
 * 			PlayerLatencyPolicies: gamelift.GameSessionQueuePlayerLatencyPolicyArray{
 * 				&gamelift.GameSessionQueuePlayerLatencyPolicyArgs{
 * 					MaximumIndividualPlayerLatencyMilliseconds: pulumi.Int(100),
 * 					PolicyDurationSeconds:                      pulumi.Int(5),
 * 				},
 * 				&gamelift.GameSessionQueuePlayerLatencyPolicyArgs{
 * 					MaximumIndividualPlayerLatencyMilliseconds: pulumi.Int(200),
 * 				},
 * 			},
 * 			TimeoutInSeconds: pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameSessionQueue;
 * import com.pulumi.aws.gamelift.GameSessionQueueArgs;
 * import com.pulumi.aws.gamelift.inputs.GameSessionQueuePlayerLatencyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GameSessionQueue("test", GameSessionQueueArgs.builder()
 *             .name("example-session-queue")
 *             .destinations(
 *                 usWest2Fleet.arn(),
 *                 euCentral1Fleet.arn())
 *             .notificationTarget(gameSessionQueueNotifications.arn())
 *             .playerLatencyPolicies(
 *                 GameSessionQueuePlayerLatencyPolicyArgs.builder()
 *                     .maximumIndividualPlayerLatencyMilliseconds(100)
 *                     .policyDurationSeconds(5)
 *                     .build(),
 *                 GameSessionQueuePlayerLatencyPolicyArgs.builder()
 *                     .maximumIndividualPlayerLatencyMilliseconds(200)
 *                     .build())
 *             .timeoutInSeconds(60)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:gamelift:GameSessionQueue
 *     properties:
 *       name: example-session-queue
 *       destinations:
 *         - ${usWest2Fleet.arn}
 *         - ${euCentral1Fleet.arn}
 *       notificationTarget: ${gameSessionQueueNotifications.arn}
 *       playerLatencyPolicies:
 *         - maximumIndividualPlayerLatencyMilliseconds: 100
 *           policyDurationSeconds: 5
 *         - maximumIndividualPlayerLatencyMilliseconds: 200
 *       timeoutInSeconds: 60
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Game Session Queues using their `name`. For example:
 * ```sh
 * $ pulumi import aws:gamelift/gameSessionQueue:GameSessionQueue example example
 * ```
 */
public class GameSessionQueue internal constructor(
    override val javaResource: com.pulumi.aws.gamelift.GameSessionQueue,
) : KotlinCustomResource(javaResource, GameSessionQueueMapper) {
    /**
     * Game Session Queue ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Information to be added to all events that are related to this game session queue.
     */
    public val customEventData: Output<String>?
        get() = javaResource.customEventData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of fleet/alias ARNs used by session queue for placing game sessions.
     */
    public val destinations: Output<List<String>>?
        get() = javaResource.destinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of the session queue.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An SNS topic ARN that is set up to receive game session placement notifications.
     */
    public val notificationTarget: Output<String>?
        get() = javaResource.notificationTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One or more policies used to choose fleet based on player latency. See below.
     */
    public val playerLatencyPolicies: Output<List<GameSessionQueuePlayerLatencyPolicy>>?
        get() = javaResource.playerLatencyPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Maximum time a game session request can remain in the queue.
     */
    public val timeoutInSeconds: Output<Int>?
        get() = javaResource.timeoutInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GameSessionQueueMapper : ResourceMapper<GameSessionQueue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.gamelift.GameSessionQueue::class == javaResource::class

    override fun map(javaResource: Resource): GameSessionQueue = GameSessionQueue(
        javaResource as
            com.pulumi.aws.gamelift.GameSessionQueue,
    )
}

/**
 * @see [GameSessionQueue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GameSessionQueue].
 */
public suspend fun gameSessionQueue(
    name: String,
    block: suspend GameSessionQueueResourceBuilder.() -> Unit,
): GameSessionQueue {
    val builder = GameSessionQueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GameSessionQueue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gameSessionQueue(name: String): GameSessionQueue {
    val builder = GameSessionQueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
