@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.MatchmakingConfigurationArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.MatchmakingConfigurationGamePropertyArgs
import com.pulumi.aws.gamelift.kotlin.inputs.MatchmakingConfigurationGamePropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a GameLift Alias resource.
 * ## Import
 * GameLift Matchmaking Configurations can be imported using the ID, e.g.,
 * ```sh
 * $ pulumi import aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration example <matchmakingconfiguration-id>
 * ```
 * @property acceptanceRequired Specifies if the match that was created with this configuration must be accepted by matched players.
 * @property acceptanceTimeoutSeconds The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
 * @property additionalPlayerCount The number of player slots in a match to keep open for future players.
 * @property backfillMode The method used to backfill game sessions that are created with this matchmaking configuration.
 * @property customEventData Information to be added to all events related to this matchmaking configuration.
 * @property description A human-readable description of the matchmaking configuration.
 * @property flexMatchMode Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
 * @property gameProperties One or more custom game properties. See below.
 * @property gameSessionData A set of custom game session properties.
 * @property gameSessionQueueArns The ARNs of the GameLift game session queue resources.
 * @property name Name of the matchmaking configuration
 * @property notificationTarget An SNS topic ARN that is set up to receive matchmaking notifications.
 * @property requestTimeoutSeconds The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
 * @property ruleSetName A rule set names for the matchmaking rule set to use with this configuration.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MatchmakingConfigurationArgs
@Deprecated(
    message = """
This resource will be removed in the next major version. Consider using
    https://www.pulumi.com/registry/packages/aws-native/api-docs/gamelift/matchmakingconfiguration/
    instead
""",
)
constructor(
    public val acceptanceRequired: Output<Boolean>? = null,
    public val acceptanceTimeoutSeconds: Output<Int>? = null,
    public val additionalPlayerCount: Output<Int>? = null,
    public val backfillMode: Output<String>? = null,
    public val customEventData: Output<String>? = null,
    public val description: Output<String>? = null,
    public val flexMatchMode: Output<String>? = null,
    public val gameProperties: Output<List<MatchmakingConfigurationGamePropertyArgs>>? = null,
    public val gameSessionData: Output<String>? = null,
    public val gameSessionQueueArns: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val notificationTarget: Output<String>? = null,
    public val requestTimeoutSeconds: Output<Int>? = null,
    public val ruleSetName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.MatchmakingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.MatchmakingConfigurationArgs =
        com.pulumi.aws.gamelift.MatchmakingConfigurationArgs.builder()
            .acceptanceRequired(acceptanceRequired?.applyValue({ args0 -> args0 }))
            .acceptanceTimeoutSeconds(acceptanceTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .additionalPlayerCount(additionalPlayerCount?.applyValue({ args0 -> args0 }))
            .backfillMode(backfillMode?.applyValue({ args0 -> args0 }))
            .customEventData(customEventData?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .flexMatchMode(flexMatchMode?.applyValue({ args0 -> args0 }))
            .gameProperties(
                gameProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gameSessionData(gameSessionData?.applyValue({ args0 -> args0 }))
            .gameSessionQueueArns(gameSessionQueueArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationTarget(notificationTarget?.applyValue({ args0 -> args0 }))
            .requestTimeoutSeconds(requestTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MatchmakingConfigurationArgs].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource will be removed in the next major version. Consider using
    https://www.pulumi.com/registry/packages/aws-native/api-docs/gamelift/matchmakingconfiguration/
    instead
""",
)
public class MatchmakingConfigurationArgsBuilder internal constructor() {
    private var acceptanceRequired: Output<Boolean>? = null

    private var acceptanceTimeoutSeconds: Output<Int>? = null

    private var additionalPlayerCount: Output<Int>? = null

    private var backfillMode: Output<String>? = null

    private var customEventData: Output<String>? = null

    private var description: Output<String>? = null

    private var flexMatchMode: Output<String>? = null

    private var gameProperties: Output<List<MatchmakingConfigurationGamePropertyArgs>>? = null

    private var gameSessionData: Output<String>? = null

    private var gameSessionQueueArns: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var notificationTarget: Output<String>? = null

    private var requestTimeoutSeconds: Output<Int>? = null

    private var ruleSetName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies if the match that was created with this configuration must be accepted by matched players.
     */
    @JvmName("uknsbjpjhgawpuxh")
    public suspend fun acceptanceRequired(`value`: Output<Boolean>) {
        this.acceptanceRequired = value
    }

    /**
     * @param value The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     */
    @JvmName("xtitcecptcubnlay")
    public suspend fun acceptanceTimeoutSeconds(`value`: Output<Int>) {
        this.acceptanceTimeoutSeconds = value
    }

    /**
     * @param value The number of player slots in a match to keep open for future players.
     */
    @JvmName("xdkisojofyywjfuw")
    public suspend fun additionalPlayerCount(`value`: Output<Int>) {
        this.additionalPlayerCount = value
    }

    /**
     * @param value The method used to backfill game sessions that are created with this matchmaking configuration.
     */
    @JvmName("laxjwdhjfdujmylh")
    public suspend fun backfillMode(`value`: Output<String>) {
        this.backfillMode = value
    }

    /**
     * @param value Information to be added to all events related to this matchmaking configuration.
     */
    @JvmName("fruormejfulpcsdd")
    public suspend fun customEventData(`value`: Output<String>) {
        this.customEventData = value
    }

    /**
     * @param value A human-readable description of the matchmaking configuration.
     */
    @JvmName("tkhtbxuwsulwyplx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
     */
    @JvmName("kikendsfmcmlaykw")
    public suspend fun flexMatchMode(`value`: Output<String>) {
        this.flexMatchMode = value
    }

    /**
     * @param value One or more custom game properties. See below.
     */
    @JvmName("sfejpucqanrclayn")
    public suspend fun gameProperties(`value`: Output<List<MatchmakingConfigurationGamePropertyArgs>>) {
        this.gameProperties = value
    }

    @JvmName("sakgedjyitjgfnmk")
    public suspend fun gameProperties(vararg values: Output<MatchmakingConfigurationGamePropertyArgs>) {
        this.gameProperties = Output.all(values.asList())
    }

    /**
     * @param values One or more custom game properties. See below.
     */
    @JvmName("ofwjptytcwusyqud")
    public suspend fun gameProperties(values: List<Output<MatchmakingConfigurationGamePropertyArgs>>) {
        this.gameProperties = Output.all(values)
    }

    /**
     * @param value A set of custom game session properties.
     */
    @JvmName("bvmbgcrelbdytttw")
    public suspend fun gameSessionData(`value`: Output<String>) {
        this.gameSessionData = value
    }

    /**
     * @param value The ARNs of the GameLift game session queue resources.
     */
    @JvmName("nrpqsvlpjwxudeqq")
    public suspend fun gameSessionQueueArns(`value`: Output<List<String>>) {
        this.gameSessionQueueArns = value
    }

    @JvmName("jqnnonewtpxpwxka")
    public suspend fun gameSessionQueueArns(vararg values: Output<String>) {
        this.gameSessionQueueArns = Output.all(values.asList())
    }

    /**
     * @param values The ARNs of the GameLift game session queue resources.
     */
    @JvmName("hnuyxbrrbotsgchp")
    public suspend fun gameSessionQueueArns(values: List<Output<String>>) {
        this.gameSessionQueueArns = Output.all(values)
    }

    /**
     * @param value Name of the matchmaking configuration
     */
    @JvmName("fcqsknsscerwvavj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An SNS topic ARN that is set up to receive matchmaking notifications.
     */
    @JvmName("nxxlvgbpkuxnyvrt")
    public suspend fun notificationTarget(`value`: Output<String>) {
        this.notificationTarget = value
    }

    /**
     * @param value The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     */
    @JvmName("jpmijbsrvmayjoln")
    public suspend fun requestTimeoutSeconds(`value`: Output<Int>) {
        this.requestTimeoutSeconds = value
    }

    /**
     * @param value A rule set names for the matchmaking rule set to use with this configuration.
     */
    @JvmName("tcdcfeogqirnenhu")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("twmsmromrjhoesir")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies if the match that was created with this configuration must be accepted by matched players.
     */
    @JvmName("pkvmkuemcaqmemmj")
    public suspend fun acceptanceRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptanceRequired = mapped
    }

    /**
     * @param value The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     */
    @JvmName("vlekdcfdiothvfmw")
    public suspend fun acceptanceTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptanceTimeoutSeconds = mapped
    }

    /**
     * @param value The number of player slots in a match to keep open for future players.
     */
    @JvmName("nwhiyposlagdpkxs")
    public suspend fun additionalPlayerCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalPlayerCount = mapped
    }

    /**
     * @param value The method used to backfill game sessions that are created with this matchmaking configuration.
     */
    @JvmName("xjiaopauathfisxg")
    public suspend fun backfillMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backfillMode = mapped
    }

    /**
     * @param value Information to be added to all events related to this matchmaking configuration.
     */
    @JvmName("kokfunpccnhscano")
    public suspend fun customEventData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEventData = mapped
    }

    /**
     * @param value A human-readable description of the matchmaking configuration.
     */
    @JvmName("afklwdagjhankmri")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
     */
    @JvmName("ntkwrpimikeacnsn")
    public suspend fun flexMatchMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flexMatchMode = mapped
    }

    /**
     * @param value One or more custom game properties. See below.
     */
    @JvmName("qpjpgawpdgpfdaeg")
    public suspend fun gameProperties(`value`: List<MatchmakingConfigurationGamePropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gameProperties = mapped
    }

    /**
     * @param argument One or more custom game properties. See below.
     */
    @JvmName("youynrsctbvmeqit")
    public suspend fun gameProperties(argument: List<suspend MatchmakingConfigurationGamePropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MatchmakingConfigurationGamePropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gameProperties = mapped
    }

    /**
     * @param argument One or more custom game properties. See below.
     */
    @JvmName("gsvhrjoxqmbkijre")
    public suspend fun gameProperties(vararg argument: suspend MatchmakingConfigurationGamePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MatchmakingConfigurationGamePropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gameProperties = mapped
    }

    /**
     * @param argument One or more custom game properties. See below.
     */
    @JvmName("shassmhyohtykvxb")
    public suspend fun gameProperties(argument: suspend MatchmakingConfigurationGamePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MatchmakingConfigurationGamePropertyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.gameProperties = mapped
    }

    /**
     * @param values One or more custom game properties. See below.
     */
    @JvmName("qvsoxhihyucdhfyn")
    public suspend fun gameProperties(vararg values: MatchmakingConfigurationGamePropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gameProperties = mapped
    }

    /**
     * @param value A set of custom game session properties.
     */
    @JvmName("xecqjbvksgbmhsgr")
    public suspend fun gameSessionData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gameSessionData = mapped
    }

    /**
     * @param value The ARNs of the GameLift game session queue resources.
     */
    @JvmName("kxifweiudrqgnvii")
    public suspend fun gameSessionQueueArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gameSessionQueueArns = mapped
    }

    /**
     * @param values The ARNs of the GameLift game session queue resources.
     */
    @JvmName("hkfokdumhdtxfpqs")
    public suspend fun gameSessionQueueArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gameSessionQueueArns = mapped
    }

    /**
     * @param value Name of the matchmaking configuration
     */
    @JvmName("ycskqxhrclsqbldq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An SNS topic ARN that is set up to receive matchmaking notifications.
     */
    @JvmName("opmxadsxxmehcaij")
    public suspend fun notificationTarget(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationTarget = mapped
    }

    /**
     * @param value The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     */
    @JvmName("kvntlvtrxepboyqu")
    public suspend fun requestTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTimeoutSeconds = mapped
    }

    /**
     * @param value A rule set names for the matchmaking rule set to use with this configuration.
     */
    @JvmName("nolrkhitguqleqjj")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vbwwsaelsscjxseu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("upipqawlukfwxwny")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MatchmakingConfigurationArgs = MatchmakingConfigurationArgs(
        acceptanceRequired = acceptanceRequired,
        acceptanceTimeoutSeconds = acceptanceTimeoutSeconds,
        additionalPlayerCount = additionalPlayerCount,
        backfillMode = backfillMode,
        customEventData = customEventData,
        description = description,
        flexMatchMode = flexMatchMode,
        gameProperties = gameProperties,
        gameSessionData = gameSessionData,
        gameSessionQueueArns = gameSessionQueueArns,
        name = name,
        notificationTarget = notificationTarget,
        requestTimeoutSeconds = requestTimeoutSeconds,
        ruleSetName = ruleSetName,
        tags = tags,
    )
}
