@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.MatchmakingRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a GameLift Matchmaking Rule Set resources.
 * ## Import
 * GameLift Matchmaking Rule Sets  can be imported using the ID, e.g.,
 * ```sh
 * $ pulumi import aws:gamelift/matchmakingRuleSet:MatchmakingRuleSet example <ruleset-id>
 * ```
 * @property name Name of the matchmaking rule set.
 * @property ruleSetBody JSON encoded string containing rule set data.
 * @property tags
 */
public data class MatchmakingRuleSetArgs
@Deprecated(
    message = """
This resource will be removed in the next major version.Consider using
    https://www.pulumi.com/registry/packages/aws-native/api-docs/gamelift/matchmakingruleset/
    instead
""",
)
constructor(
    public val name: Output<String>? = null,
    public val ruleSetBody: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.MatchmakingRuleSetArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.MatchmakingRuleSetArgs =
        com.pulumi.aws.gamelift.MatchmakingRuleSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleSetBody(ruleSetBody?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MatchmakingRuleSetArgs].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource will be removed in the next major version.Consider using
    https://www.pulumi.com/registry/packages/aws-native/api-docs/gamelift/matchmakingruleset/
    instead
""",
)
public class MatchmakingRuleSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var ruleSetBody: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the matchmaking rule set.
     */
    @JvmName("jcftrhisfwloyurh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value JSON encoded string containing rule set data.
     */
    @JvmName("lvtehutgqkdrmhuh")
    public suspend fun ruleSetBody(`value`: Output<String>) {
        this.ruleSetBody = value
    }

    /**
     * @param value
     */
    @JvmName("hhimacyanxhamogg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the matchmaking rule set.
     */
    @JvmName("yxesvvptautwvvqb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value JSON encoded string containing rule set data.
     */
    @JvmName("jfvgdenhbxqhkhci")
    public suspend fun ruleSetBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetBody = mapped
    }

    /**
     * @param value
     */
    @JvmName("oycsrwjwghtqxjay")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("aeppwhxgjjljbdgw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MatchmakingRuleSetArgs = MatchmakingRuleSetArgs(
        name = name,
        ruleSetBody = ruleSetBody,
        tags = tags,
    )
}
