@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.ScriptArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.ScriptStorageLocationArgs
import com.pulumi.aws.gamelift.kotlin.inputs.ScriptStorageLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an GameLift Script resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.gamelift.Script("example", {
 *     name: "example-script",
 *     storageLocation: {
 *         bucket: exampleAwsS3Bucket.id,
 *         key: exampleAwsS3Object.key,
 *         roleArn: exampleAwsIamRole.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.gamelift.Script("example",
 *     name="example-script",
 *     storage_location={
 *         "bucket": example_aws_s3_bucket["id"],
 *         "key": example_aws_s3_object["key"],
 *         "role_arn": example_aws_iam_role["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GameLift.Script("example", new()
 *     {
 *         Name = "example-script",
 *         StorageLocation = new Aws.GameLift.Inputs.ScriptStorageLocationArgs
 *         {
 *             Bucket = exampleAwsS3Bucket.Id,
 *             Key = exampleAwsS3Object.Key,
 *             RoleArn = exampleAwsIamRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/gamelift"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gamelift.NewScript(ctx, "example", &gamelift.ScriptArgs{
 * 			Name: pulumi.String("example-script"),
 * 			StorageLocation: &gamelift.ScriptStorageLocationArgs{
 * 				Bucket:  pulumi.Any(exampleAwsS3Bucket.Id),
 * 				Key:     pulumi.Any(exampleAwsS3Object.Key),
 * 				RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Script;
 * import com.pulumi.aws.gamelift.ScriptArgs;
 * import com.pulumi.aws.gamelift.inputs.ScriptStorageLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Script("example", ScriptArgs.builder()
 *             .name("example-script")
 *             .storageLocation(ScriptStorageLocationArgs.builder()
 *                 .bucket(exampleAwsS3Bucket.id())
 *                 .key(exampleAwsS3Object.key())
 *                 .roleArn(exampleAwsIamRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:gamelift:Script
 *     properties:
 *       name: example-script
 *       storageLocation:
 *         bucket: ${exampleAwsS3Bucket.id}
 *         key: ${exampleAwsS3Object.key}
 *         roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GameLift Scripts using the ID. For example:
 * ```sh
 * $ pulumi import aws:gamelift/script:Script example <script-id>
 * ```
 * @property name Name of the script
 * @property storageLocation Information indicating where your game script files are stored. See below.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property version Version that is associated with this script.
 * @property zipFile A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
 */
public data class ScriptArgs(
    public val name: Output<String>? = null,
    public val storageLocation: Output<ScriptStorageLocationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
    public val zipFile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.ScriptArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.ScriptArgs =
        com.pulumi.aws.gamelift.ScriptArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .storageLocation(storageLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 }))
            .zipFile(zipFile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptArgs].
 */
@PulumiTagMarker
public class ScriptArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var storageLocation: Output<ScriptStorageLocationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    private var zipFile: Output<String>? = null

    /**
     * @param value Name of the script
     */
    @JvmName("qjpelgqeikaeojcd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Information indicating where your game script files are stored. See below.
     */
    @JvmName("hmdelodyrxdtswwq")
    public suspend fun storageLocation(`value`: Output<ScriptStorageLocationArgs>) {
        this.storageLocation = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("inbdmwnjsxbjvfno")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Version that is associated with this script.
     */
    @JvmName("wpgdjjheabslpshc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
     */
    @JvmName("naofixsnhgduexid")
    public suspend fun zipFile(`value`: Output<String>) {
        this.zipFile = value
    }

    /**
     * @param value Name of the script
     */
    @JvmName("pxbwkeusjgssldgx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Information indicating where your game script files are stored. See below.
     */
    @JvmName("xhwcjluqglivbnvd")
    public suspend fun storageLocation(`value`: ScriptStorageLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLocation = mapped
    }

    /**
     * @param argument Information indicating where your game script files are stored. See below.
     */
    @JvmName("gpauxxrvfxgvyoil")
    public suspend fun storageLocation(argument: suspend ScriptStorageLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ScriptStorageLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageLocation = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mcaesepjilnidqwj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ehliryobfkokvjcg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Version that is associated with this script.
     */
    @JvmName("riaucstdqxyjasak")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
     */
    @JvmName("pwxhagfbaehahihk")
    public suspend fun zipFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipFile = mapped
    }

    internal fun build(): ScriptArgs = ScriptArgs(
        name = name,
        storageLocation = storageLocation,
        tags = tags,
        version = version,
        zipFile = zipFile,
    )
}
