@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.AliasRoutingStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fleetId ID of the GameLift Fleet to point the alias to.
 * @property message Message text to be used with the `TERMINAL` routing strategy.
 * @property type Type of routing strategyE.g., `SIMPLE` or `TERMINAL`
 */
public data class AliasRoutingStrategyArgs(
    public val fleetId: Output<String>? = null,
    public val message: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.AliasRoutingStrategyArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.AliasRoutingStrategyArgs =
        com.pulumi.aws.gamelift.inputs.AliasRoutingStrategyArgs.builder()
            .fleetId(fleetId?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AliasRoutingStrategyArgs].
 */
@PulumiTagMarker
public class AliasRoutingStrategyArgsBuilder internal constructor() {
    private var fleetId: Output<String>? = null

    private var message: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value ID of the GameLift Fleet to point the alias to.
     */
    @JvmName("reddqxkbqtokwqyf")
    public suspend fun fleetId(`value`: Output<String>) {
        this.fleetId = value
    }

    /**
     * @param value Message text to be used with the `TERMINAL` routing strategy.
     */
    @JvmName("ismkueuqqmewsjvl")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Type of routing strategyE.g., `SIMPLE` or `TERMINAL`
     */
    @JvmName("wndpgjqgslpgupat")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ID of the GameLift Fleet to point the alias to.
     */
    @JvmName("atwikagvxtiorfvj")
    public suspend fun fleetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetId = mapped
    }

    /**
     * @param value Message text to be used with the `TERMINAL` routing strategy.
     */
    @JvmName("tbeoomrblgdaldxg")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Type of routing strategyE.g., `SIMPLE` or `TERMINAL`
     */
    @JvmName("mkmdsbafcikrsddw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AliasRoutingStrategyArgs = AliasRoutingStrategyArgs(
        fleetId = fleetId,
        message = message,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
