@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationServerProcessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property concurrentExecutions Number of server processes using this configuration to run concurrently on an instance.
 * @property launchPath Location of the server executable in a game build. All game builds are installed on instances at the root : for Windows instances `C:\game`, and for Linux instances `/local/game`.
 * @property parameters Optional list of parameters to pass to the server executable on launch.
 */
public data class FleetRuntimeConfigurationServerProcessArgs(
    public val concurrentExecutions: Output<Int>,
    public val launchPath: Output<String>,
    public val parameters: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationServerProcessArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationServerProcessArgs =
        com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationServerProcessArgs.builder()
            .concurrentExecutions(concurrentExecutions.applyValue({ args0 -> args0 }))
            .launchPath(launchPath.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetRuntimeConfigurationServerProcessArgs].
 */
@PulumiTagMarker
public class FleetRuntimeConfigurationServerProcessArgsBuilder internal constructor() {
    private var concurrentExecutions: Output<Int>? = null

    private var launchPath: Output<String>? = null

    private var parameters: Output<String>? = null

    /**
     * @param value Number of server processes using this configuration to run concurrently on an instance.
     */
    @JvmName("ivejodkfvpvnithv")
    public suspend fun concurrentExecutions(`value`: Output<Int>) {
        this.concurrentExecutions = value
    }

    /**
     * @param value Location of the server executable in a game build. All game builds are installed on instances at the root : for Windows instances `C:\game`, and for Linux instances `/local/game`.
     */
    @JvmName("cpkweogjkqoddlvd")
    public suspend fun launchPath(`value`: Output<String>) {
        this.launchPath = value
    }

    /**
     * @param value Optional list of parameters to pass to the server executable on launch.
     */
    @JvmName("hmphnqxauxnxfoja")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value Number of server processes using this configuration to run concurrently on an instance.
     */
    @JvmName("klmotrrkqpwjvdca")
    public suspend fun concurrentExecutions(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.concurrentExecutions = mapped
    }

    /**
     * @param value Location of the server executable in a game build. All game builds are installed on instances at the root : for Windows instances `C:\game`, and for Linux instances `/local/game`.
     */
    @JvmName("sgniauoqjkekbgjv")
    public suspend fun launchPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchPath = mapped
    }

    /**
     * @param value Optional list of parameters to pass to the server executable on launch.
     */
    @JvmName("xepskfpsejowkqaq")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): FleetRuntimeConfigurationServerProcessArgs =
        FleetRuntimeConfigurationServerProcessArgs(
            concurrentExecutions = concurrentExecutions ?: throw
                PulumiNullFieldException("concurrentExecutions"),
            launchPath = launchPath ?: throw PulumiNullFieldException("launchPath"),
            parameters = parameters,
        )
}
