@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property estimatedInstanceWarmup Length of time, in seconds, it takes for a new instance to start
 * new game server processes and register with GameLift FleetIQ.
 * Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up,
 * because it avoids prematurely starting new instances. Defaults to `60`.
 * @property targetTrackingConfiguration
 */
public data class GameServerGroupAutoScalingPolicyArgs(
    public val estimatedInstanceWarmup: Output<Int>? = null,
    public val targetTrackingConfiguration: Output<GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs>,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyArgs =
        com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyArgs.builder()
            .estimatedInstanceWarmup(estimatedInstanceWarmup?.applyValue({ args0 -> args0 }))
            .targetTrackingConfiguration(
                targetTrackingConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GameServerGroupAutoScalingPolicyArgs].
 */
@PulumiTagMarker
public class GameServerGroupAutoScalingPolicyArgsBuilder internal constructor() {
    private var estimatedInstanceWarmup: Output<Int>? = null

    private var targetTrackingConfiguration:
        Output<GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs>? = null

    /**
     * @param value Length of time, in seconds, it takes for a new instance to start
     * new game server processes and register with GameLift FleetIQ.
     * Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up,
     * because it avoids prematurely starting new instances. Defaults to `60`.
     */
    @JvmName("aycxpvchpwomaqxc")
    public suspend fun estimatedInstanceWarmup(`value`: Output<Int>) {
        this.estimatedInstanceWarmup = value
    }

    /**
     * @param value
     */
    @JvmName("tucoutyqchjlmqht")
    public suspend fun targetTrackingConfiguration(`value`: Output<GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs>) {
        this.targetTrackingConfiguration = value
    }

    /**
     * @param value Length of time, in seconds, it takes for a new instance to start
     * new game server processes and register with GameLift FleetIQ.
     * Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up,
     * because it avoids prematurely starting new instances. Defaults to `60`.
     */
    @JvmName("sqgqjtcvutsfipli")
    public suspend fun estimatedInstanceWarmup(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.estimatedInstanceWarmup = mapped
    }

    /**
     * @param value
     */
    @JvmName("trifmpgwdlblycct")
    public suspend fun targetTrackingConfiguration(`value`: GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetTrackingConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("btmxwhvaqawsddah")
    public suspend fun targetTrackingConfiguration(argument: suspend GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.targetTrackingConfiguration = mapped
    }

    internal fun build(): GameServerGroupAutoScalingPolicyArgs = GameServerGroupAutoScalingPolicyArgs(
        estimatedInstanceWarmup = estimatedInstanceWarmup,
        targetTrackingConfiguration = targetTrackingConfiguration ?: throw
            PulumiNullFieldException("targetTrackingConfiguration"),
    )
}
