@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType An EC2 instance type.
 * @property weightedCapacity Instance weighting that indicates how much this instance type contributes
 * to the total capacity of a game server group.
 * Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify
 * the most cost-effective options.
 */
public data class GameServerGroupInstanceDefinitionArgs(
    public val instanceType: Output<String>,
    public val weightedCapacity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs =
        com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GameServerGroupInstanceDefinitionArgs].
 */
@PulumiTagMarker
public class GameServerGroupInstanceDefinitionArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var weightedCapacity: Output<String>? = null

    /**
     * @param value An EC2 instance type.
     */
    @JvmName("aovdvphxgyqcsdsd")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Instance weighting that indicates how much this instance type contributes
     * to the total capacity of a game server group.
     * Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify
     * the most cost-effective options.
     */
    @JvmName("eilmovttjxsmnqwt")
    public suspend fun weightedCapacity(`value`: Output<String>) {
        this.weightedCapacity = value
    }

    /**
     * @param value An EC2 instance type.
     */
    @JvmName("juglxapfjdetmdkd")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Instance weighting that indicates how much this instance type contributes
     * to the total capacity of a game server group.
     * Instance weights are used by GameLift FleetIQ to calculate the instance type's cost per unit hour and better identify
     * the most cost-effective options.
     */
    @JvmName("qkegxbhxlqhgyppc")
    public suspend fun weightedCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): GameServerGroupInstanceDefinitionArgs =
        GameServerGroupInstanceDefinitionArgs(
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            weightedCapacity = weightedCapacity,
        )
}
