@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.GameSessionQueuePlayerLatencyPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumIndividualPlayerLatencyMilliseconds Maximum latency value that is allowed for any player.
 * @property policyDurationSeconds Length of time that the policy is enforced while placing a new game session. Absence of value for this attribute means that the policy is enforced until the queue times out.
 */
public data class GameSessionQueuePlayerLatencyPolicyArgs(
    public val maximumIndividualPlayerLatencyMilliseconds: Output<Int>,
    public val policyDurationSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.GameSessionQueuePlayerLatencyPolicyArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.GameSessionQueuePlayerLatencyPolicyArgs =
        com.pulumi.aws.gamelift.inputs.GameSessionQueuePlayerLatencyPolicyArgs.builder()
            .maximumIndividualPlayerLatencyMilliseconds(
                maximumIndividualPlayerLatencyMilliseconds.applyValue({ args0 ->
                    args0
                }),
            )
            .policyDurationSeconds(policyDurationSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GameSessionQueuePlayerLatencyPolicyArgs].
 */
@PulumiTagMarker
public class GameSessionQueuePlayerLatencyPolicyArgsBuilder internal constructor() {
    private var maximumIndividualPlayerLatencyMilliseconds: Output<Int>? = null

    private var policyDurationSeconds: Output<Int>? = null

    /**
     * @param value Maximum latency value that is allowed for any player.
     */
    @JvmName("ycevagxqclopuusk")
    public suspend fun maximumIndividualPlayerLatencyMilliseconds(`value`: Output<Int>) {
        this.maximumIndividualPlayerLatencyMilliseconds = value
    }

    /**
     * @param value Length of time that the policy is enforced while placing a new game session. Absence of value for this attribute means that the policy is enforced until the queue times out.
     */
    @JvmName("xwpqtasrcidsefgr")
    public suspend fun policyDurationSeconds(`value`: Output<Int>) {
        this.policyDurationSeconds = value
    }

    /**
     * @param value Maximum latency value that is allowed for any player.
     */
    @JvmName("aykdoiguhpuojews")
    public suspend fun maximumIndividualPlayerLatencyMilliseconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumIndividualPlayerLatencyMilliseconds = mapped
    }

    /**
     * @param value Length of time that the policy is enforced while placing a new game session. Absence of value for this attribute means that the policy is enforced until the queue times out.
     */
    @JvmName("hvpqhmlfmgwqtekf")
    public suspend fun policyDurationSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDurationSeconds = mapped
    }

    internal fun build(): GameSessionQueuePlayerLatencyPolicyArgs =
        GameSessionQueuePlayerLatencyPolicyArgs(
            maximumIndividualPlayerLatencyMilliseconds = maximumIndividualPlayerLatencyMilliseconds ?: throw
                PulumiNullFieldException("maximumIndividualPlayerLatencyMilliseconds"),
            policyDurationSeconds = policyDurationSeconds,
        )
}
