@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property concurrentExecutions Number of server processes using this configuration to run concurrently on an instance.
 * @property launchPath Location of the server executable in a game build. All game builds are installed on instances at the root : for Windows instances `C:\game`, and for Linux instances `/local/game`.
 * @property parameters Optional list of parameters to pass to the server executable on launch.
 */
public data class FleetRuntimeConfigurationServerProcess(
    public val concurrentExecutions: Int,
    public val launchPath: String,
    public val parameters: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.FleetRuntimeConfigurationServerProcess): FleetRuntimeConfigurationServerProcess = FleetRuntimeConfigurationServerProcess(
            concurrentExecutions = javaType.concurrentExecutions(),
            launchPath = javaType.launchPath(),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
        )
    }
}
