@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id A unique identifier for an existing EC2 launch template.
 * @property name A readable identifier for an existing EC2 launch template.
 * @property version The version of the EC2 launch template to use. If none is set, the default is the first version created.
 */
public data class GameServerGroupLaunchTemplate(
    public val id: String? = null,
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.GameServerGroupLaunchTemplate): GameServerGroupLaunchTemplate = GameServerGroupLaunchTemplate(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
