@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumIndividualPlayerLatencyMilliseconds Maximum latency value that is allowed for any player.
 * @property policyDurationSeconds Length of time that the policy is enforced while placing a new game session. Absence of value for this attribute means that the policy is enforced until the queue times out.
 */
public data class GameSessionQueuePlayerLatencyPolicy(
    public val maximumIndividualPlayerLatencyMilliseconds: Int,
    public val policyDurationSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.GameSessionQueuePlayerLatencyPolicy): GameSessionQueuePlayerLatencyPolicy = GameSessionQueuePlayerLatencyPolicy(
            maximumIndividualPlayerLatencyMilliseconds = javaType.maximumIndividualPlayerLatencyMilliseconds(),
            policyDurationSeconds = javaType.policyDurationSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
