@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket Name of your S3 bucket.
 * @property key Name of the zip file containing your script files.
 * @property objectVersion A specific version of the file. If not set, the latest version of the file is retrieved.
 * @property roleArn ARN of the access role that allows Amazon GameLift to access your S3 bucket.
 */
public data class ScriptStorageLocation(
    public val bucket: String,
    public val key: String,
    public val objectVersion: String? = null,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.gamelift.outputs.ScriptStorageLocation): ScriptStorageLocation = ScriptStorageLocation(
            bucket = javaType.bucket(),
            key = javaType.key(),
            objectVersion = javaType.objectVersion().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
        )
    }
}
