@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glacier.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VaultLock].
 */
@PulumiTagMarker
public class VaultLockResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultLockArgs = VaultLockArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultLockArgsBuilder.() -> Unit) {
        val builder = VaultLockArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VaultLock {
        val builtJavaResource = com.pulumi.aws.glacier.VaultLock(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VaultLock(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Testing Glacier Vault Lock Policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleVault = new aws.glacier.Vault("example", {name: "example"});
 * const example = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         actions: ["glacier:DeleteArchive"],
 *         effect: "Deny",
 *         resources: [exampleVault&#46;arn],
 *         conditions: [{
 *             test: "NumericLessThanEquals",
 *             variable: "glacier:ArchiveAgeinDays",
 *             values: ["365"],
 *         }],
 *     }],
 * });
 * const exampleVaultLock = new aws.glacier.VaultLock("example", {
 *     completeLock: false,
 *     policy: example.apply(example => example.json),
 *     vaultName: exampleVault.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_vault = aws.glacier.Vault("example", name="example")
 * example = aws.iam.get_policy_document_output(statements=[{
 *     "actions": ["glacier:DeleteArchive"],
 *     "effect": "Deny",
 *     "resources": [example_vault&#46;arn],
 *     "conditions": [{
 *         "test": "NumericLessThanEquals",
 *         "variable": "glacier:ArchiveAgeinDays",
 *         "values": ["365"],
 *     }],
 * }])
 * example_vault_lock = aws.glacier.VaultLock("example",
 *     complete_lock=False,
 *     policy=example.json,
 *     vault_name=example_vault.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleVault = new Aws.Glacier.Vault("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "glacier:DeleteArchive",
 *                 },
 *                 Effect = "Deny",
 *                 Resources = new[]
 *                 {
 *                     exampleVault.Arn,
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "NumericLessThanEquals",
 *                         Variable = "glacier:ArchiveAgeinDays",
 *                         Values = new[]
 *                         {
 *                             "365",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleVaultLock = new Aws.Glacier.VaultLock("example", new()
 *     {
 *         CompleteLock = false,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         VaultName = exampleVault.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glacier"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleVault, err := glacier.NewVault(ctx, "example", &glacier.VaultArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("glacier:DeleteArchive"),
 * 					},
 * 					Effect: pulumi.String("Deny"),
 * 					Resources: pulumi.StringArray{
 * 						exampleVault.Arn,
 * 					},
 * 					Conditions: iam.GetPolicyDocumentStatementConditionArray{
 * 						&iam.GetPolicyDocumentStatementConditionArgs{
 * 							Test:     pulumi.String("NumericLessThanEquals"),
 * 							Variable: pulumi.String("glacier:ArchiveAgeinDays"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("365"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = glacier.NewVaultLock(ctx, "example", &glacier.VaultLockArgs{
 * 			CompleteLock: pulumi.Bool(false),
 * 			Policy: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &example.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			VaultName: exampleVault.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glacier.Vault;
 * import com.pulumi.aws.glacier.VaultArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.glacier.VaultLock;
 * import com.pulumi.aws.glacier.VaultLockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVault = new Vault("exampleVault", VaultArgs.builder()
 *             .name("example")
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("glacier:DeleteArchive")
 *                 .effect("Deny")
 *                 .resources(exampleVault.arn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("NumericLessThanEquals")
 *                     .variable("glacier:ArchiveAgeinDays")
 *                     .values("365")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleVaultLock = new VaultLock("exampleVaultLock", VaultLockArgs.builder()
 *             .completeLock(false)
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .vaultName(exampleVault.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleVault:
 *     type: aws:glacier:Vault
 *     name: example
 *     properties:
 *       name: example
 *   exampleVaultLock:
 *     type: aws:glacier:VaultLock
 *     name: example
 *     properties:
 *       completeLock: false
 *       policy: ${example.json}
 *       vaultName: ${exampleVault.name}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - glacier:DeleteArchive
 *             effect: Deny
 *             resources:
 *               - ${exampleVault.arn}
 *             conditions:
 *               - test: NumericLessThanEquals
 *                 variable: glacier:ArchiveAgeinDays
 *                 values:
 *                   - '365'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Permanently Applying Glacier Vault Lock Policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glacier.VaultLock("example", {
 *     completeLock: true,
 *     policy: exampleAwsIamPolicyDocument.json,
 *     vaultName: exampleAwsGlacierVault.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glacier.VaultLock("example",
 *     complete_lock=True,
 *     policy=example_aws_iam_policy_document["json"],
 *     vault_name=example_aws_glacier_vault["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glacier.VaultLock("example", new()
 *     {
 *         CompleteLock = true,
 *         Policy = exampleAwsIamPolicyDocument.Json,
 *         VaultName = exampleAwsGlacierVault.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glacier"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glacier.NewVaultLock(ctx, "example", &glacier.VaultLockArgs{
 * 			CompleteLock: pulumi.Bool(true),
 * 			Policy:       pulumi.Any(exampleAwsIamPolicyDocument.Json),
 * 			VaultName:    pulumi.Any(exampleAwsGlacierVault.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glacier.VaultLock;
 * import com.pulumi.aws.glacier.VaultLockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VaultLock("example", VaultLockArgs.builder()
 *             .completeLock(true)
 *             .policy(exampleAwsIamPolicyDocument.json())
 *             .vaultName(exampleAwsGlacierVault.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glacier:VaultLock
 *     properties:
 *       completeLock: true
 *       policy: ${exampleAwsIamPolicyDocument.json}
 *       vaultName: ${exampleAwsGlacierVault.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glacier Vault Locks using the Glacier Vault name. For example:
 * ```sh
 * $ pulumi import aws:glacier/vaultLock:VaultLock example example-vault
 * ```
 */
public class VaultLock internal constructor(
    override val javaResource: com.pulumi.aws.glacier.VaultLock,
) : KotlinCustomResource(javaResource, VaultLockMapper) {
    /**
     * Boolean whether to permanently apply this Glacier Lock Policy. Once completed, this cannot be undone. If set to `false`, the Glacier Lock Policy remains in a testing mode for 24 hours. After that time, the Glacier Lock Policy is automatically removed by Glacier and the this provider resource will show as needing recreation. Changing this from `false` to `true` will show as resource recreation, which is expected. Changing this from `true` to `false` is not possible unless the Glacier Vault is recreated at the same time.
     */
    public val completeLock: Output<Boolean>
        get() = javaResource.completeLock().applyValue({ args0 -> args0 })

    /**
     * Allow this provider to ignore the error returned when attempting to delete the Glacier Lock Policy. This can be used to delete or recreate the Glacier Vault via this provider, for example, if the Glacier Vault Lock policy permits that action. This should only be used in conjunction with `complete_lock` being set to `true`.
     */
    public val ignoreDeletionError: Output<Boolean>?
        get() = javaResource.ignoreDeletionError().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * JSON string containing the IAM policy to apply as the Glacier Vault Lock policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The name of the Glacier Vault.
     */
    public val vaultName: Output<String>
        get() = javaResource.vaultName().applyValue({ args0 -> args0 })
}

public object VaultLockMapper : ResourceMapper<VaultLock> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glacier.VaultLock::class == javaResource::class

    override fun map(javaResource: Resource): VaultLock = VaultLock(
        javaResource as
            com.pulumi.aws.glacier.VaultLock,
    )
}

/**
 * @see [VaultLock].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VaultLock].
 */
public suspend fun vaultLock(name: String, block: suspend VaultLockResourceBuilder.() -> Unit): VaultLock {
    val builder = VaultLockResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VaultLock].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vaultLock(name: String): VaultLock {
    val builder = VaultLockResourceBuilder()
    builder.name(name)
    return builder.build()
}
