@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.AcceleratorArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.AcceleratorAttributesArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.AcceleratorAttributesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a Global Accelerator accelerator.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.Accelerator("example", {
 *     name: "Example",
 *     ipAddressType: "IPV4",
 *     ipAddresses: ["1&#46;2&#46;3&#46;4"],
 *     enabled: true,
 *     attributes: {
 *         flowLogsEnabled: true,
 *         flowLogsS3Bucket: "example-bucket",
 *         flowLogsS3Prefix: "flow-logs/",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.Accelerator("example",
 *     name="Example",
 *     ip_address_type="IPV4",
 *     ip_addresses=["1&#46;2&#46;3&#46;4"],
 *     enabled=True,
 *     attributes={
 *         "flow_logs_enabled": True,
 *         "flow_logs_s3_bucket": "example-bucket",
 *         "flow_logs_s3_prefix": "flow-logs/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.Accelerator("example", new()
 *     {
 *         Name = "Example",
 *         IpAddressType = "IPV4",
 *         IpAddresses = new[]
 *         {
 *             "1.2.3.4",
 *         },
 *         Enabled = true,
 *         Attributes = new Aws.GlobalAccelerator.Inputs.AcceleratorAttributesArgs
 *         {
 *             FlowLogsEnabled = true,
 *             FlowLogsS3Bucket = "example-bucket",
 *             FlowLogsS3Prefix = "flow-logs/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := globalaccelerator.NewAccelerator(ctx, "example", &globalaccelerator.AcceleratorArgs{
 * 			Name:          pulumi.String("Example"),
 * 			IpAddressType: pulumi.String("IPV4"),
 * 			IpAddresses: pulumi.StringArray{
 * 				pulumi.String("1.2.3.4"),
 * 			},
 * 			Enabled: pulumi.Bool(true),
 * 			Attributes: &globalaccelerator.AcceleratorAttributesArgs{
 * 				FlowLogsEnabled:  pulumi.Bool(true),
 * 				FlowLogsS3Bucket: pulumi.String("example-bucket"),
 * 				FlowLogsS3Prefix: pulumi.String("flow-logs/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.Accelerator;
 * import com.pulumi.aws.globalaccelerator.AcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Accelerator("example", AcceleratorArgs.builder()
 *             .name("Example")
 *             .ipAddressType("IPV4")
 *             .ipAddresses("1.2.3.4")
 *             .enabled(true)
 *             .attributes(AcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:Accelerator
 *     properties:
 *       name: Example
 *       ipAddressType: IPV4
 *       ipAddresses:
 *         - 1.2.3.4
 *       enabled: true
 *       attributes:
 *         flowLogsEnabled: true
 *         flowLogsS3Bucket: example-bucket
 *         flowLogsS3Prefix: flow-logs/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator accelerators using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/accelerator:Accelerator example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
 * ```
 * @property attributes The attributes of the accelerator. Fields documented below.
 * @property enabled Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
 * @property ipAddressType The value for the address type. Defaults to `IPV4`. Valid values: `IPV4`, `DUAL_STACK`.
 * @property ipAddresses The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
 * @property name The name of the accelerator.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AcceleratorArgs(
    public val attributes: Output<AcceleratorAttributesArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val ipAddressType: Output<String>? = null,
    public val ipAddresses: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.AcceleratorArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.AcceleratorArgs =
        com.pulumi.aws.globalaccelerator.AcceleratorArgs.builder()
            .attributes(attributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AcceleratorArgs].
 */
@PulumiTagMarker
public class AcceleratorArgsBuilder internal constructor() {
    private var attributes: Output<AcceleratorAttributesArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var ipAddressType: Output<String>? = null

    private var ipAddresses: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The attributes of the accelerator. Fields documented below.
     */
    @JvmName("eapdhhyimdsqiynb")
    public suspend fun attributes(`value`: Output<AcceleratorAttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
     */
    @JvmName("gencsycivgttsffj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The value for the address type. Defaults to `IPV4`. Valid values: `IPV4`, `DUAL_STACK`.
     */
    @JvmName("nspjkrjegpdqkkor")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("layfushbfuhlscen")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("mmphjxuiifkpxhgk")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("cmmkadwoctppdosi")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value The name of the accelerator.
     */
    @JvmName("yjgfrmoysxjwrigj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nwobxsxcdtvnrkcb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The attributes of the accelerator. Fields documented below.
     */
    @JvmName("urbgmjaxsouhgnac")
    public suspend fun attributes(`value`: AcceleratorAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of the accelerator. Fields documented below.
     */
    @JvmName("goyuxmcjbdffbush")
    public suspend fun attributes(argument: suspend AcceleratorAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = AcceleratorAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
     */
    @JvmName("qwhgbvjfhvvicshc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The value for the address type. Defaults to `IPV4`. Valid values: `IPV4`, `DUAL_STACK`.
     */
    @JvmName("snajqrpxcxkfcffq")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("dvvtwvfgdrbnlhyl")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("rawtuvfnfwtbtepq")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value The name of the accelerator.
     */
    @JvmName("xpqpkenwfghqjuou")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ydfordpwpkakruwi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mbnrggnicohpqxke")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AcceleratorArgs = AcceleratorArgs(
        attributes = attributes,
        enabled = enabled,
        ipAddressType = ipAddressType,
        ipAddresses = ipAddresses,
        name = name,
        tags = tags,
    )
}
