@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.kotlin.outputs.CrossAccountAttachmentResource
import com.pulumi.aws.globalaccelerator.kotlin.outputs.CrossAccountAttachmentResource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [CrossAccountAttachment].
 */
@PulumiTagMarker
public class CrossAccountAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CrossAccountAttachmentArgs = CrossAccountAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CrossAccountAttachmentArgsBuilder.() -> Unit) {
        val builder = CrossAccountAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CrossAccountAttachment {
        val builtJavaResource =
            com.pulumi.aws.globalaccelerator.CrossAccountAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CrossAccountAttachment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Global Accelerator Cross Account Attachment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.CrossAccountAttachment("example", {name: "example-cross-account-attachment"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.CrossAccountAttachment("example", name="example-cross-account-attachment")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.CrossAccountAttachment("example", new()
 *     {
 *         Name = "example-cross-account-attachment",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := globalaccelerator.NewCrossAccountAttachment(ctx, "example", &globalaccelerator.CrossAccountAttachmentArgs{
 * 			Name: pulumi.String("example-cross-account-attachment"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CrossAccountAttachment;
 * import com.pulumi.aws.globalaccelerator.CrossAccountAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CrossAccountAttachment("example", CrossAccountAttachmentArgs.builder()
 *             .name("example-cross-account-attachment")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:CrossAccountAttachment
 *     properties:
 *       name: example-cross-account-attachment
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with Optional Arguments
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.CrossAccountAttachment("example", {
 *     name: "example-cross-account-attachment",
 *     principals: ["123456789012"],
 *     resources: [{
 *         endpointId: "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
 *         region: "us-west-2",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.CrossAccountAttachment("example",
 *     name="example-cross-account-attachment",
 *     principals=["123456789012"],
 *     resources=[{
 *         "endpoint_id": "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
 *         "region": "us-west-2",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.CrossAccountAttachment("example", new()
 *     {
 *         Name = "example-cross-account-attachment",
 *         Principals = new[]
 *         {
 *             "123456789012",
 *         },
 *         Resources = new[]
 *         {
 *             new Aws.GlobalAccelerator.Inputs.CrossAccountAttachmentResourceArgs
 *             {
 *                 EndpointId = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
 *                 Region = "us-west-2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := globalaccelerator.NewCrossAccountAttachment(ctx, "example", &globalaccelerator.CrossAccountAttachmentArgs{
 * 			Name: pulumi.String("example-cross-account-attachment"),
 * 			Principals: pulumi.StringArray{
 * 				pulumi.String("123456789012"),
 * 			},
 * 			Resources: globalaccelerator.CrossAccountAttachmentResourceArray{
 * 				&globalaccelerator.CrossAccountAttachmentResourceArgs{
 * 					EndpointId: pulumi.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
 * 					Region:     pulumi.String("us-west-2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CrossAccountAttachment;
 * import com.pulumi.aws.globalaccelerator.CrossAccountAttachmentArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CrossAccountAttachmentResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CrossAccountAttachment("example", CrossAccountAttachmentArgs.builder()
 *             .name("example-cross-account-attachment")
 *             .principals("123456789012")
 *             .resources(CrossAccountAttachmentResourceArgs.builder()
 *                 .endpointId("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188")
 *                 .region("us-west-2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:CrossAccountAttachment
 *     properties:
 *       name: example-cross-account-attachment
 *       principals:
 *         - '123456789012'
 *       resources:
 *         - endpointId: arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188
 *           region: us-west-2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator Cross Account Attachment using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/crossAccountAttachment:CrossAccountAttachment example arn:aws:globalaccelerator::012345678910:attachment/01234567-abcd-8910-efgh-123456789012
 * ```
 */
public class CrossAccountAttachment internal constructor(
    override val javaResource: com.pulumi.aws.globalaccelerator.CrossAccountAttachment,
) : KotlinCustomResource(javaResource, CrossAccountAttachmentMapper) {
    /**
     * ARN of the Cross Account Attachment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation Time when the Cross Account Attachment.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Last modified time of the Cross Account Attachment.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * Name of the Cross Account Attachment.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of AWS account IDs that are allowed to associate resources with the accelerator.
     */
    public val principals: Output<List<String>>?
        get() = javaResource.principals().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * List of resources to be associated with the accelerator.
     */
    public val resources: Output<List<CrossAccountAttachmentResource>>?
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CrossAccountAttachmentMapper : ResourceMapper<CrossAccountAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.globalaccelerator.CrossAccountAttachment::class == javaResource::class

    override fun map(javaResource: Resource): CrossAccountAttachment =
        CrossAccountAttachment(
            javaResource as
                com.pulumi.aws.globalaccelerator.CrossAccountAttachment,
        )
}

/**
 * @see [CrossAccountAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CrossAccountAttachment].
 */
public suspend fun crossAccountAttachment(
    name: String,
    block: suspend CrossAccountAttachmentResourceBuilder.() -> Unit,
): CrossAccountAttachment {
    val builder = CrossAccountAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CrossAccountAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun crossAccountAttachment(name: String): CrossAccountAttachment {
    val builder = CrossAccountAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
