@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.CrossAccountAttachmentArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CrossAccountAttachmentResourceArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CrossAccountAttachmentResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Global Accelerator Cross Account Attachment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.CrossAccountAttachment("example", {name: "example-cross-account-attachment"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.CrossAccountAttachment("example", name="example-cross-account-attachment")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.CrossAccountAttachment("example", new()
 *     {
 *         Name = "example-cross-account-attachment",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := globalaccelerator.NewCrossAccountAttachment(ctx, "example", &globalaccelerator.CrossAccountAttachmentArgs{
 * 			Name: pulumi.String("example-cross-account-attachment"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CrossAccountAttachment;
 * import com.pulumi.aws.globalaccelerator.CrossAccountAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CrossAccountAttachment("example", CrossAccountAttachmentArgs.builder()
 *             .name("example-cross-account-attachment")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:CrossAccountAttachment
 *     properties:
 *       name: example-cross-account-attachment
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with Optional Arguments
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.CrossAccountAttachment("example", {
 *     name: "example-cross-account-attachment",
 *     principals: ["123456789012"],
 *     resources: [{
 *         endpointId: "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
 *         region: "us-west-2",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.CrossAccountAttachment("example",
 *     name="example-cross-account-attachment",
 *     principals=["123456789012"],
 *     resources=[{
 *         "endpoint_id": "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
 *         "region": "us-west-2",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.CrossAccountAttachment("example", new()
 *     {
 *         Name = "example-cross-account-attachment",
 *         Principals = new[]
 *         {
 *             "123456789012",
 *         },
 *         Resources = new[]
 *         {
 *             new Aws.GlobalAccelerator.Inputs.CrossAccountAttachmentResourceArgs
 *             {
 *                 EndpointId = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
 *                 Region = "us-west-2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := globalaccelerator.NewCrossAccountAttachment(ctx, "example", &globalaccelerator.CrossAccountAttachmentArgs{
 * 			Name: pulumi.String("example-cross-account-attachment"),
 * 			Principals: pulumi.StringArray{
 * 				pulumi.String("123456789012"),
 * 			},
 * 			Resources: globalaccelerator.CrossAccountAttachmentResourceArray{
 * 				&globalaccelerator.CrossAccountAttachmentResourceArgs{
 * 					EndpointId: pulumi.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
 * 					Region:     pulumi.String("us-west-2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CrossAccountAttachment;
 * import com.pulumi.aws.globalaccelerator.CrossAccountAttachmentArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CrossAccountAttachmentResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CrossAccountAttachment("example", CrossAccountAttachmentArgs.builder()
 *             .name("example-cross-account-attachment")
 *             .principals("123456789012")
 *             .resources(CrossAccountAttachmentResourceArgs.builder()
 *                 .endpointId("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188")
 *                 .region("us-west-2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:CrossAccountAttachment
 *     properties:
 *       name: example-cross-account-attachment
 *       principals:
 *         - '123456789012'
 *       resources:
 *         - endpointId: arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188
 *           region: us-west-2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator Cross Account Attachment using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/crossAccountAttachment:CrossAccountAttachment example arn:aws:globalaccelerator::012345678910:attachment/01234567-abcd-8910-efgh-123456789012
 * ```
 * @property name Name of the Cross Account Attachment.
 * The following arguments are optional:
 * @property principals List of AWS account IDs that are allowed to associate resources with the accelerator.
 * @property resources List of resources to be associated with the accelerator.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CrossAccountAttachmentArgs(
    public val name: Output<String>? = null,
    public val principals: Output<List<String>>? = null,
    public val resources: Output<List<CrossAccountAttachmentResourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.CrossAccountAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.CrossAccountAttachmentArgs =
        com.pulumi.aws.globalaccelerator.CrossAccountAttachmentArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .principals(principals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resources(
                resources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CrossAccountAttachmentArgs].
 */
@PulumiTagMarker
public class CrossAccountAttachmentArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var principals: Output<List<String>>? = null

    private var resources: Output<List<CrossAccountAttachmentResourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Cross Account Attachment.
     * The following arguments are optional:
     */
    @JvmName("bwtvdarthraslmtu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of AWS account IDs that are allowed to associate resources with the accelerator.
     */
    @JvmName("nhtoocbrpjjcunwc")
    public suspend fun principals(`value`: Output<List<String>>) {
        this.principals = value
    }

    @JvmName("ruavohbdddlwapml")
    public suspend fun principals(vararg values: Output<String>) {
        this.principals = Output.all(values.asList())
    }

    /**
     * @param values List of AWS account IDs that are allowed to associate resources with the accelerator.
     */
    @JvmName("wfxvfatbrrrfyqfn")
    public suspend fun principals(values: List<Output<String>>) {
        this.principals = Output.all(values)
    }

    /**
     * @param value List of resources to be associated with the accelerator.
     */
    @JvmName("oqiebxwuantesniw")
    public suspend fun resources(`value`: Output<List<CrossAccountAttachmentResourceArgs>>) {
        this.resources = value
    }

    @JvmName("rlcsmqbhgbdcboyr")
    public suspend fun resources(vararg values: Output<CrossAccountAttachmentResourceArgs>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values List of resources to be associated with the accelerator.
     */
    @JvmName("ysrcrtnuhcaueqye")
    public suspend fun resources(values: List<Output<CrossAccountAttachmentResourceArgs>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pyfdlovonujlixij")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Cross Account Attachment.
     * The following arguments are optional:
     */
    @JvmName("nglqrfqrvobsmivq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of AWS account IDs that are allowed to associate resources with the accelerator.
     */
    @JvmName("pulahdgewwlmbnxk")
    public suspend fun principals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principals = mapped
    }

    /**
     * @param values List of AWS account IDs that are allowed to associate resources with the accelerator.
     */
    @JvmName("lmmtkswfjdbhpwts")
    public suspend fun principals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principals = mapped
    }

    /**
     * @param value List of resources to be associated with the accelerator.
     */
    @JvmName("fjpbustjvrrnojfx")
    public suspend fun resources(`value`: List<CrossAccountAttachmentResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument List of resources to be associated with the accelerator.
     */
    @JvmName("mejemjrlnawkwhfq")
    public suspend fun resources(argument: List<suspend CrossAccountAttachmentResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrossAccountAttachmentResourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param argument List of resources to be associated with the accelerator.
     */
    @JvmName("udbeekjqoqbhaukf")
    public suspend fun resources(vararg argument: suspend CrossAccountAttachmentResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrossAccountAttachmentResourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param argument List of resources to be associated with the accelerator.
     */
    @JvmName("ismbnitshpoxfkym")
    public suspend fun resources(argument: suspend CrossAccountAttachmentResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CrossAccountAttachmentResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param values List of resources to be associated with the accelerator.
     */
    @JvmName("eonutlvmxinyybon")
    public suspend fun resources(vararg values: CrossAccountAttachmentResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qclsyarwjfkhqeas")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yxpnwfmskbdwuudn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CrossAccountAttachmentArgs = CrossAccountAttachmentArgs(
        name = name,
        principals = principals,
        resources = resources,
        tags = tags,
    )
}
