@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingAcceleratorAttributesArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingAcceleratorAttributesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a Global Accelerator custom routing accelerator.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.CustomRoutingAccelerator("example", {
 *     name: "Example",
 *     ipAddressType: "IPV4",
 *     ipAddresses: ["1&#46;2&#46;3&#46;4"],
 *     enabled: true,
 *     attributes: {
 *         flowLogsEnabled: true,
 *         flowLogsS3Bucket: "example-bucket",
 *         flowLogsS3Prefix: "flow-logs/",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.CustomRoutingAccelerator("example",
 *     name="Example",
 *     ip_address_type="IPV4",
 *     ip_addresses=["1&#46;2&#46;3&#46;4"],
 *     enabled=True,
 *     attributes={
 *         "flow_logs_enabled": True,
 *         "flow_logs_s3_bucket": "example-bucket",
 *         "flow_logs_s3_prefix": "flow-logs/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.CustomRoutingAccelerator("example", new()
 *     {
 *         Name = "Example",
 *         IpAddressType = "IPV4",
 *         IpAddresses = new[]
 *         {
 *             "1.2.3.4",
 *         },
 *         Enabled = true,
 *         Attributes = new Aws.GlobalAccelerator.Inputs.CustomRoutingAcceleratorAttributesArgs
 *         {
 *             FlowLogsEnabled = true,
 *             FlowLogsS3Bucket = "example-bucket",
 *             FlowLogsS3Prefix = "flow-logs/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := globalaccelerator.NewCustomRoutingAccelerator(ctx, "example", &globalaccelerator.CustomRoutingAcceleratorArgs{
 * 			Name:          pulumi.String("Example"),
 * 			IpAddressType: pulumi.String("IPV4"),
 * 			IpAddresses: pulumi.StringArray{
 * 				pulumi.String("1.2.3.4"),
 * 			},
 * 			Enabled: pulumi.Bool(true),
 * 			Attributes: &globalaccelerator.CustomRoutingAcceleratorAttributesArgs{
 * 				FlowLogsEnabled:  pulumi.Bool(true),
 * 				FlowLogsS3Bucket: pulumi.String("example-bucket"),
 * 				FlowLogsS3Prefix: pulumi.String("flow-logs/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingAcceleratorAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomRoutingAccelerator("example", CustomRoutingAcceleratorArgs.builder()
 *             .name("Example")
 *             .ipAddressType("IPV4")
 *             .ipAddresses("1.2.3.4")
 *             .enabled(true)
 *             .attributes(CustomRoutingAcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:CustomRoutingAccelerator
 *     properties:
 *       name: Example
 *       ipAddressType: IPV4
 *       ipAddresses:
 *         - 1.2.3.4
 *       enabled: true
 *       attributes:
 *         flowLogsEnabled: true
 *         flowLogsS3Bucket: example-bucket
 *         flowLogsS3Prefix: flow-logs/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing accelerators using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/customRoutingAccelerator:CustomRoutingAccelerator example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
 * ```
 * @property attributes The attributes of the accelerator. Fields documented below.
 * @property enabled Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
 * @property ipAddressType The IP address type that an accelerator supports. For a custom routing accelerator, the value must be `"IPV4"`.
 * @property ipAddresses The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
 * @property name The name of a custom routing accelerator.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CustomRoutingAcceleratorArgs(
    public val attributes: Output<CustomRoutingAcceleratorAttributesArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val ipAddressType: Output<String>? = null,
    public val ipAddresses: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs =
        com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs.builder()
            .attributes(attributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomRoutingAcceleratorArgs].
 */
@PulumiTagMarker
public class CustomRoutingAcceleratorArgsBuilder internal constructor() {
    private var attributes: Output<CustomRoutingAcceleratorAttributesArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var ipAddressType: Output<String>? = null

    private var ipAddresses: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The attributes of the accelerator. Fields documented below.
     */
    @JvmName("prgungpqjprqhike")
    public suspend fun attributes(`value`: Output<CustomRoutingAcceleratorAttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
     */
    @JvmName("iujhfiqbgthwfyhc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The IP address type that an accelerator supports. For a custom routing accelerator, the value must be `"IPV4"`.
     */
    @JvmName("lkvemgultnrynnap")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("eqwioxwoxballlvi")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("jotsgfyhijrmuffv")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("mhldjdgcbcsokujj")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value The name of a custom routing accelerator.
     */
    @JvmName("uyameperesaxdvtt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eduvhlkwpqiwltiy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The attributes of the accelerator. Fields documented below.
     */
    @JvmName("djdbmhuvpfxjjahu")
    public suspend fun attributes(`value`: CustomRoutingAcceleratorAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of the accelerator. Fields documented below.
     */
    @JvmName("mykwbeklwjuviyyb")
    public suspend fun attributes(argument: suspend CustomRoutingAcceleratorAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = CustomRoutingAcceleratorAttributesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value Indicates whether the accelerator is enabled. Defaults to `true`. Valid values: `true`, `false`.
     */
    @JvmName("qajpwmxxoetdpxop")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The IP address type that an accelerator supports. For a custom routing accelerator, the value must be `"IPV4"`.
     */
    @JvmName("frhxgolpmhxnrawk")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("luubormeilsotnod")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
     */
    @JvmName("boufkushyqqdkump")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value The name of a custom routing accelerator.
     */
    @JvmName("jxrmhgrkjynxdcjf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("toxxwaxmthxojvwq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ydqhmaxxijmhdkbn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomRoutingAcceleratorArgs = CustomRoutingAcceleratorArgs(
        attributes = attributes,
        enabled = enabled,
        ipAddressType = ipAddressType,
        ipAddresses = ipAddresses,
        name = name,
        tags = tags,
    )
}
