@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator custom routing endpoint group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.CustomRoutingEndpointGroup("example", {
 *     listenerArn: exampleAwsGlobalacceleratorCustomRoutingListener.id,
 *     destinationConfigurations: [{
 *         fromPort: 80,
 *         toPort: 8080,
 *         protocols: ["TCP"],
 *     }],
 *     endpointConfigurations: [{
 *         endpointId: exampleAwsSubnet.id,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.CustomRoutingEndpointGroup("example",
 *     listener_arn=example_aws_globalaccelerator_custom_routing_listener["id"],
 *     destination_configurations=[{
 *         "from_port": 80,
 *         "to_port": 8080,
 *         "protocols": ["TCP"],
 *     }],
 *     endpoint_configurations=[{
 *         "endpoint_id": example_aws_subnet["id"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.CustomRoutingEndpointGroup("example", new()
 *     {
 *         ListenerArn = exampleAwsGlobalacceleratorCustomRoutingListener.Id,
 *         DestinationConfigurations = new[]
 *         {
 *             new Aws.GlobalAccelerator.Inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs
 *             {
 *                 FromPort = 80,
 *                 ToPort = 8080,
 *                 Protocols = new[]
 *                 {
 *                     "TCP",
 *                 },
 *             },
 *         },
 *         EndpointConfigurations = new[]
 *         {
 *             new Aws.GlobalAccelerator.Inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs
 *             {
 *                 EndpointId = exampleAwsSubnet.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := globalaccelerator.NewCustomRoutingEndpointGroup(ctx, "example", &globalaccelerator.CustomRoutingEndpointGroupArgs{
 * 			ListenerArn: pulumi.Any(exampleAwsGlobalacceleratorCustomRoutingListener.Id),
 * 			DestinationConfigurations: globalaccelerator.CustomRoutingEndpointGroupDestinationConfigurationArray{
 * 				&globalaccelerator.CustomRoutingEndpointGroupDestinationConfigurationArgs{
 * 					FromPort: pulumi.Int(80),
 * 					ToPort:   pulumi.Int(8080),
 * 					Protocols: pulumi.StringArray{
 * 						pulumi.String("TCP"),
 * 					},
 * 				},
 * 			},
 * 			EndpointConfigurations: globalaccelerator.CustomRoutingEndpointGroupEndpointConfigurationArray{
 * 				&globalaccelerator.CustomRoutingEndpointGroupEndpointConfigurationArgs{
 * 					EndpointId: pulumi.Any(exampleAwsSubnet.Id),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroup;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupEndpointConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomRoutingEndpointGroup("example", CustomRoutingEndpointGroupArgs.builder()
 *             .listenerArn(exampleAwsGlobalacceleratorCustomRoutingListener.id())
 *             .destinationConfigurations(CustomRoutingEndpointGroupDestinationConfigurationArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(8080)
 *                 .protocols("TCP")
 *                 .build())
 *             .endpointConfigurations(CustomRoutingEndpointGroupEndpointConfigurationArgs.builder()
 *                 .endpointId(exampleAwsSubnet.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:CustomRoutingEndpointGroup
 *     properties:
 *       listenerArn: ${exampleAwsGlobalacceleratorCustomRoutingListener.id}
 *       destinationConfigurations:
 *         - fromPort: 80
 *           toPort: 8080
 *           protocols:
 *             - TCP
 *       endpointConfigurations:
 *         - endpointId: ${exampleAwsSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing endpoint groups using the `id`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/customRoutingEndpointGroup:CustomRoutingEndpointGroup example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxx/endpoint-group/xxxxxxxx
 * ```
 * @property destinationConfigurations The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
 * @property endpointConfigurations The list of endpoint objects. Fields documented below.
 * @property endpointGroupRegion The name of the AWS Region where the custom routing endpoint group is located.
 * @property listenerArn The Amazon Resource Name (ARN) of the custom routing listener.
 */
public data class CustomRoutingEndpointGroupArgs(
    public val destinationConfigurations: Output<List<CustomRoutingEndpointGroupDestinationConfigurationArgs>>? = null,
    public val endpointConfigurations: Output<List<CustomRoutingEndpointGroupEndpointConfigurationArgs>>? = null,
    public val endpointGroupRegion: Output<String>? = null,
    public val listenerArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs =
        com.pulumi.aws.globalaccelerator.CustomRoutingEndpointGroupArgs.builder()
            .destinationConfigurations(
                destinationConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointConfigurations(
                endpointConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointGroupRegion(endpointGroupRegion?.applyValue({ args0 -> args0 }))
            .listenerArn(listenerArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRoutingEndpointGroupArgs].
 */
@PulumiTagMarker
public class CustomRoutingEndpointGroupArgsBuilder internal constructor() {
    private var destinationConfigurations:
        Output<List<CustomRoutingEndpointGroupDestinationConfigurationArgs>>? = null

    private var endpointConfigurations:
        Output<List<CustomRoutingEndpointGroupEndpointConfigurationArgs>>? = null

    private var endpointGroupRegion: Output<String>? = null

    private var listenerArn: Output<String>? = null

    /**
     * @param value The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("hpmwjyuuutyolggg")
    public suspend fun destinationConfigurations(`value`: Output<List<CustomRoutingEndpointGroupDestinationConfigurationArgs>>) {
        this.destinationConfigurations = value
    }

    @JvmName("tnkagbxwqyxuavxi")
    public suspend fun destinationConfigurations(vararg values: Output<CustomRoutingEndpointGroupDestinationConfigurationArgs>) {
        this.destinationConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("nkvmwmslniyqtmac")
    public suspend fun destinationConfigurations(values: List<Output<CustomRoutingEndpointGroupDestinationConfigurationArgs>>) {
        this.destinationConfigurations = Output.all(values)
    }

    /**
     * @param value The list of endpoint objects. Fields documented below.
     */
    @JvmName("dbpidvuokuuvarni")
    public suspend fun endpointConfigurations(`value`: Output<List<CustomRoutingEndpointGroupEndpointConfigurationArgs>>) {
        this.endpointConfigurations = value
    }

    @JvmName("iydrbiajswsvbbka")
    public suspend fun endpointConfigurations(vararg values: Output<CustomRoutingEndpointGroupEndpointConfigurationArgs>) {
        this.endpointConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The list of endpoint objects. Fields documented below.
     */
    @JvmName("wcmajnopcsgcffnn")
    public suspend fun endpointConfigurations(values: List<Output<CustomRoutingEndpointGroupEndpointConfigurationArgs>>) {
        this.endpointConfigurations = Output.all(values)
    }

    /**
     * @param value The name of the AWS Region where the custom routing endpoint group is located.
     */
    @JvmName("lydseptxvjnsxyyq")
    public suspend fun endpointGroupRegion(`value`: Output<String>) {
        this.endpointGroupRegion = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the custom routing listener.
     */
    @JvmName("jwsfrtnkahkkxrpp")
    public suspend fun listenerArn(`value`: Output<String>) {
        this.listenerArn = value
    }

    /**
     * @param value The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("votvwfmiqxjiaflc")
    public suspend fun destinationConfigurations(`value`: List<CustomRoutingEndpointGroupDestinationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("cvsthhvvlxahmvst")
    public suspend fun destinationConfigurations(argument: List<suspend CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("dudjmtqbtpdnyvnl")
    public suspend fun destinationConfigurations(vararg argument: suspend CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param argument The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("yrwmqnnjxelfmcwt")
    public suspend fun destinationConfigurations(argument: suspend CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.destinationConfigurations = mapped
    }

    /**
     * @param values The port ranges and protocols for all endpoints in a custom routing endpoint group to accept client traffic on. Fields documented below.
     */
    @JvmName("qvttcychncsfglwi")
    public suspend fun destinationConfigurations(vararg values: CustomRoutingEndpointGroupDestinationConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationConfigurations = mapped
    }

    /**
     * @param value The list of endpoint objects. Fields documented below.
     */
    @JvmName("xqfnpmtkogsqgxum")
    public suspend fun endpointConfigurations(`value`: List<CustomRoutingEndpointGroupEndpointConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("yqohblbbitikqdvu")
    public suspend fun endpointConfigurations(argument: List<suspend CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("qxcbccdwclbegccu")
    public suspend fun endpointConfigurations(vararg argument: suspend CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param argument The list of endpoint objects. Fields documented below.
     */
    @JvmName("wwtrbgnkcruuntqj")
    public suspend fun endpointConfigurations(argument: suspend CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                CustomRoutingEndpointGroupEndpointConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.endpointConfigurations = mapped
    }

    /**
     * @param values The list of endpoint objects. Fields documented below.
     */
    @JvmName("talgxgoybyyapycu")
    public suspend fun endpointConfigurations(vararg values: CustomRoutingEndpointGroupEndpointConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointConfigurations = mapped
    }

    /**
     * @param value The name of the AWS Region where the custom routing endpoint group is located.
     */
    @JvmName("vogndqmdirypnxvy")
    public suspend fun endpointGroupRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointGroupRegion = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the custom routing listener.
     */
    @JvmName("vqlihnokwdgxplin")
    public suspend fun listenerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerArn = mapped
    }

    internal fun build(): CustomRoutingEndpointGroupArgs = CustomRoutingEndpointGroupArgs(
        destinationConfigurations = destinationConfigurations,
        endpointConfigurations = endpointConfigurations,
        endpointGroupRegion = endpointGroupRegion,
        listenerArn = listenerArn,
    )
}
