@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingListenerPortRange
import com.pulumi.aws.globalaccelerator.kotlin.outputs.CustomRoutingListenerPortRange.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [CustomRoutingListener].
 */
@PulumiTagMarker
public class CustomRoutingListenerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomRoutingListenerArgs = CustomRoutingListenerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomRoutingListenerArgsBuilder.() -> Unit) {
        val builder = CustomRoutingListenerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomRoutingListener {
        val builtJavaResource =
            com.pulumi.aws.globalaccelerator.CustomRoutingListener(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomRoutingListener(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator custom routing listener.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.CustomRoutingAccelerator("example", {
 *     name: "Example",
 *     ipAddressType: "IPV4",
 *     enabled: true,
 *     attributes: {
 *         flowLogsEnabled: true,
 *         flowLogsS3Bucket: "example-bucket",
 *         flowLogsS3Prefix: "flow-logs/",
 *     },
 * });
 * const exampleCustomRoutingListener = new aws.globalaccelerator.CustomRoutingListener("example", {
 *     acceleratorArn: example.id,
 *     portRanges: [{
 *         fromPort: 80,
 *         toPort: 80,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.CustomRoutingAccelerator("example",
 *     name="Example",
 *     ip_address_type="IPV4",
 *     enabled=True,
 *     attributes={
 *         "flow_logs_enabled": True,
 *         "flow_logs_s3_bucket": "example-bucket",
 *         "flow_logs_s3_prefix": "flow-logs/",
 *     })
 * example_custom_routing_listener = aws.globalaccelerator.CustomRoutingListener("example",
 *     accelerator_arn=example.id,
 *     port_ranges=[{
 *         "from_port": 80,
 *         "to_port": 80,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.CustomRoutingAccelerator("example", new()
 *     {
 *         Name = "Example",
 *         IpAddressType = "IPV4",
 *         Enabled = true,
 *         Attributes = new Aws.GlobalAccelerator.Inputs.CustomRoutingAcceleratorAttributesArgs
 *         {
 *             FlowLogsEnabled = true,
 *             FlowLogsS3Bucket = "example-bucket",
 *             FlowLogsS3Prefix = "flow-logs/",
 *         },
 *     });
 *     var exampleCustomRoutingListener = new Aws.GlobalAccelerator.CustomRoutingListener("example", new()
 *     {
 *         AcceleratorArn = example.Id,
 *         PortRanges = new[]
 *         {
 *             new Aws.GlobalAccelerator.Inputs.CustomRoutingListenerPortRangeArgs
 *             {
 *                 FromPort = 80,
 *                 ToPort = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := globalaccelerator.NewCustomRoutingAccelerator(ctx, "example", &globalaccelerator.CustomRoutingAcceleratorArgs{
 * 			Name:          pulumi.String("Example"),
 * 			IpAddressType: pulumi.String("IPV4"),
 * 			Enabled:       pulumi.Bool(true),
 * 			Attributes: &globalaccelerator.CustomRoutingAcceleratorAttributesArgs{
 * 				FlowLogsEnabled:  pulumi.Bool(true),
 * 				FlowLogsS3Bucket: pulumi.String("example-bucket"),
 * 				FlowLogsS3Prefix: pulumi.String("flow-logs/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = globalaccelerator.NewCustomRoutingListener(ctx, "example", &globalaccelerator.CustomRoutingListenerArgs{
 * 			AcceleratorArn: example.ID(),
 * 			PortRanges: globalaccelerator.CustomRoutingListenerPortRangeArray{
 * 				&globalaccelerator.CustomRoutingListenerPortRangeArgs{
 * 					FromPort: pulumi.Int(80),
 * 					ToPort:   pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingAcceleratorAttributesArgs;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingListener;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingListenerPortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomRoutingAccelerator("example", CustomRoutingAcceleratorArgs.builder()
 *             .name("Example")
 *             .ipAddressType("IPV4")
 *             .enabled(true)
 *             .attributes(CustomRoutingAcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .build());
 *         var exampleCustomRoutingListener = new CustomRoutingListener("exampleCustomRoutingListener", CustomRoutingListenerArgs.builder()
 *             .acceleratorArn(example.id())
 *             .portRanges(CustomRoutingListenerPortRangeArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:CustomRoutingAccelerator
 *     properties:
 *       name: Example
 *       ipAddressType: IPV4
 *       enabled: true
 *       attributes:
 *         flowLogsEnabled: true
 *         flowLogsS3Bucket: example-bucket
 *         flowLogsS3Prefix: flow-logs/
 *   exampleCustomRoutingListener:
 *     type: aws:globalaccelerator:CustomRoutingListener
 *     name: example
 *     properties:
 *       acceleratorArn: ${example.id}
 *       portRanges:
 *         - fromPort: 80
 *           toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing listeners using the `id`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/customRoutingListener:CustomRoutingListener example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxxx
 * ```
 */
public class CustomRoutingListener internal constructor(
    override val javaResource: com.pulumi.aws.globalaccelerator.CustomRoutingListener,
) : KotlinCustomResource(javaResource, CustomRoutingListenerMapper) {
    /**
     * The Amazon Resource Name (ARN) of a custom routing accelerator.
     */
    public val acceleratorArn: Output<String>
        get() = javaResource.acceleratorArn().applyValue({ args0 -> args0 })

    /**
     * The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    public val portRanges: Output<List<CustomRoutingListenerPortRange>>
        get() = javaResource.portRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object CustomRoutingListenerMapper : ResourceMapper<CustomRoutingListener> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.globalaccelerator.CustomRoutingListener::class == javaResource::class

    override fun map(javaResource: Resource): CustomRoutingListener =
        CustomRoutingListener(javaResource as com.pulumi.aws.globalaccelerator.CustomRoutingListener)
}

/**
 * @see [CustomRoutingListener].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomRoutingListener].
 */
public suspend fun customRoutingListener(
    name: String,
    block: suspend CustomRoutingListenerResourceBuilder.() -> Unit,
): CustomRoutingListener {
    val builder = CustomRoutingListenerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomRoutingListener].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customRoutingListener(name: String): CustomRoutingListener {
    val builder = CustomRoutingListenerResourceBuilder()
    builder.name(name)
    return builder.build()
}
