@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingListenerPortRangeArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.CustomRoutingListenerPortRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator custom routing listener.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.CustomRoutingAccelerator("example", {
 *     name: "Example",
 *     ipAddressType: "IPV4",
 *     enabled: true,
 *     attributes: {
 *         flowLogsEnabled: true,
 *         flowLogsS3Bucket: "example-bucket",
 *         flowLogsS3Prefix: "flow-logs/",
 *     },
 * });
 * const exampleCustomRoutingListener = new aws.globalaccelerator.CustomRoutingListener("example", {
 *     acceleratorArn: example.id,
 *     portRanges: [{
 *         fromPort: 80,
 *         toPort: 80,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.CustomRoutingAccelerator("example",
 *     name="Example",
 *     ip_address_type="IPV4",
 *     enabled=True,
 *     attributes={
 *         "flow_logs_enabled": True,
 *         "flow_logs_s3_bucket": "example-bucket",
 *         "flow_logs_s3_prefix": "flow-logs/",
 *     })
 * example_custom_routing_listener = aws.globalaccelerator.CustomRoutingListener("example",
 *     accelerator_arn=example.id,
 *     port_ranges=[{
 *         "from_port": 80,
 *         "to_port": 80,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.CustomRoutingAccelerator("example", new()
 *     {
 *         Name = "Example",
 *         IpAddressType = "IPV4",
 *         Enabled = true,
 *         Attributes = new Aws.GlobalAccelerator.Inputs.CustomRoutingAcceleratorAttributesArgs
 *         {
 *             FlowLogsEnabled = true,
 *             FlowLogsS3Bucket = "example-bucket",
 *             FlowLogsS3Prefix = "flow-logs/",
 *         },
 *     });
 *     var exampleCustomRoutingListener = new Aws.GlobalAccelerator.CustomRoutingListener("example", new()
 *     {
 *         AcceleratorArn = example.Id,
 *         PortRanges = new[]
 *         {
 *             new Aws.GlobalAccelerator.Inputs.CustomRoutingListenerPortRangeArgs
 *             {
 *                 FromPort = 80,
 *                 ToPort = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := globalaccelerator.NewCustomRoutingAccelerator(ctx, "example", &globalaccelerator.CustomRoutingAcceleratorArgs{
 * 			Name:          pulumi.String("Example"),
 * 			IpAddressType: pulumi.String("IPV4"),
 * 			Enabled:       pulumi.Bool(true),
 * 			Attributes: &globalaccelerator.CustomRoutingAcceleratorAttributesArgs{
 * 				FlowLogsEnabled:  pulumi.Bool(true),
 * 				FlowLogsS3Bucket: pulumi.String("example-bucket"),
 * 				FlowLogsS3Prefix: pulumi.String("flow-logs/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = globalaccelerator.NewCustomRoutingListener(ctx, "example", &globalaccelerator.CustomRoutingListenerArgs{
 * 			AcceleratorArn: example.ID(),
 * 			PortRanges: globalaccelerator.CustomRoutingListenerPortRangeArray{
 * 				&globalaccelerator.CustomRoutingListenerPortRangeArgs{
 * 					FromPort: pulumi.Int(80),
 * 					ToPort:   pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAccelerator;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingAcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingAcceleratorAttributesArgs;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingListener;
 * import com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingListenerPortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomRoutingAccelerator("example", CustomRoutingAcceleratorArgs.builder()
 *             .name("Example")
 *             .ipAddressType("IPV4")
 *             .enabled(true)
 *             .attributes(CustomRoutingAcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .build());
 *         var exampleCustomRoutingListener = new CustomRoutingListener("exampleCustomRoutingListener", CustomRoutingListenerArgs.builder()
 *             .acceleratorArn(example.id())
 *             .portRanges(CustomRoutingListenerPortRangeArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:CustomRoutingAccelerator
 *     properties:
 *       name: Example
 *       ipAddressType: IPV4
 *       enabled: true
 *       attributes:
 *         flowLogsEnabled: true
 *         flowLogsS3Bucket: example-bucket
 *         flowLogsS3Prefix: flow-logs/
 *   exampleCustomRoutingListener:
 *     type: aws:globalaccelerator:CustomRoutingListener
 *     name: example
 *     properties:
 *       acceleratorArn: ${example.id}
 *       portRanges:
 *         - fromPort: 80
 *           toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator custom routing listeners using the `id`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/customRoutingListener:CustomRoutingListener example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxxx
 * ```
 * @property acceleratorArn The Amazon Resource Name (ARN) of a custom routing accelerator.
 * @property portRanges The list of port ranges for the connections from clients to the accelerator. Fields documented below.
 */
public data class CustomRoutingListenerArgs(
    public val acceleratorArn: Output<String>? = null,
    public val portRanges: Output<List<CustomRoutingListenerPortRangeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs =
        com.pulumi.aws.globalaccelerator.CustomRoutingListenerArgs.builder()
            .acceleratorArn(acceleratorArn?.applyValue({ args0 -> args0 }))
            .portRanges(
                portRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomRoutingListenerArgs].
 */
@PulumiTagMarker
public class CustomRoutingListenerArgsBuilder internal constructor() {
    private var acceleratorArn: Output<String>? = null

    private var portRanges: Output<List<CustomRoutingListenerPortRangeArgs>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of a custom routing accelerator.
     */
    @JvmName("icoqetjpwajcrjud")
    public suspend fun acceleratorArn(`value`: Output<String>) {
        this.acceleratorArn = value
    }

    /**
     * @param value The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("jicfmorqmfjsnqwt")
    public suspend fun portRanges(`value`: Output<List<CustomRoutingListenerPortRangeArgs>>) {
        this.portRanges = value
    }

    @JvmName("retwyeqhybbrwpot")
    public suspend fun portRanges(vararg values: Output<CustomRoutingListenerPortRangeArgs>) {
        this.portRanges = Output.all(values.asList())
    }

    /**
     * @param values The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("vyxgxfunslpjgdrf")
    public suspend fun portRanges(values: List<Output<CustomRoutingListenerPortRangeArgs>>) {
        this.portRanges = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of a custom routing accelerator.
     */
    @JvmName("seluugojuecsgxav")
    public suspend fun acceleratorArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorArn = mapped
    }

    /**
     * @param value The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("goymjljvegtjxyop")
    public suspend fun portRanges(`value`: List<CustomRoutingListenerPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("ceecivswtynluiry")
    public suspend fun portRanges(argument: List<suspend CustomRoutingListenerPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomRoutingListenerPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("ttputqalyfiuicnv")
    public suspend fun portRanges(vararg argument: suspend CustomRoutingListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomRoutingListenerPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("hgxuyxchmkafflai")
    public suspend fun portRanges(argument: suspend CustomRoutingListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomRoutingListenerPortRangeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param values The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("ipddrxipwokqvtdl")
    public suspend fun portRanges(vararg values: CustomRoutingListenerPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    internal fun build(): CustomRoutingListenerArgs = CustomRoutingListenerArgs(
        acceleratorArn = acceleratorArn,
        portRanges = portRanges,
    )
}
