@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.kotlin.outputs.EndpointGroupEndpointConfiguration
import com.pulumi.aws.globalaccelerator.kotlin.outputs.EndpointGroupPortOverride
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.globalaccelerator.kotlin.outputs.EndpointGroupEndpointConfiguration.Companion.toKotlin as endpointGroupEndpointConfigurationToKotlin
import com.pulumi.aws.globalaccelerator.kotlin.outputs.EndpointGroupPortOverride.Companion.toKotlin as endpointGroupPortOverrideToKotlin

/**
 * Builder for [EndpointGroup].
 */
@PulumiTagMarker
public class EndpointGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointGroupArgs = EndpointGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointGroupArgsBuilder.() -> Unit) {
        val builder = EndpointGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EndpointGroup {
        val builtJavaResource = com.pulumi.aws.globalaccelerator.EndpointGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EndpointGroup(builtJavaResource)
    }
}

/**
 * Provides a Global Accelerator endpoint group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.EndpointGroup("example", {
 *     listenerArn: exampleAwsGlobalacceleratorListener.id,
 *     endpointConfigurations: [{
 *         endpointId: exampleAwsLb.arn,
 *         weight: 100,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.EndpointGroup("example",
 *     listener_arn=example_aws_globalaccelerator_listener["id"],
 *     endpoint_configurations=[{
 *         "endpoint_id": example_aws_lb["arn"],
 *         "weight": 100,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.EndpointGroup("example", new()
 *     {
 *         ListenerArn = exampleAwsGlobalacceleratorListener.Id,
 *         EndpointConfigurations = new[]
 *         {
 *             new Aws.GlobalAccelerator.Inputs.EndpointGroupEndpointConfigurationArgs
 *             {
 *                 EndpointId = exampleAwsLb.Arn,
 *                 Weight = 100,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := globalaccelerator.NewEndpointGroup(ctx, "example", &globalaccelerator.EndpointGroupArgs{
 * 			ListenerArn: pulumi.Any(exampleAwsGlobalacceleratorListener.Id),
 * 			EndpointConfigurations: globalaccelerator.EndpointGroupEndpointConfigurationArray{
 * 				&globalaccelerator.EndpointGroupEndpointConfigurationArgs{
 * 					EndpointId: pulumi.Any(exampleAwsLb.Arn),
 * 					Weight:     pulumi.Int(100),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.EndpointGroup;
 * import com.pulumi.aws.globalaccelerator.EndpointGroupArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.EndpointGroupEndpointConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointGroup("example", EndpointGroupArgs.builder()
 *             .listenerArn(exampleAwsGlobalacceleratorListener.id())
 *             .endpointConfigurations(EndpointGroupEndpointConfigurationArgs.builder()
 *                 .endpointId(exampleAwsLb.arn())
 *                 .weight(100)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:EndpointGroup
 *     properties:
 *       listenerArn: ${exampleAwsGlobalacceleratorListener.id}
 *       endpointConfigurations:
 *         - endpointId: ${exampleAwsLb.arn}
 *           weight: 100
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator endpoint groups using the `id`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/endpointGroup:EndpointGroup example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxx/endpoint-group/xxxxxxxx
 * ```
 */
public class EndpointGroup internal constructor(
    override val javaResource: com.pulumi.aws.globalaccelerator.EndpointGroup,
) : KotlinCustomResource(javaResource, EndpointGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) of the endpoint group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The list of endpoint objects. Fields documented below.
     */
    public val endpointConfigurations: Output<List<EndpointGroupEndpointConfiguration>>?
        get() = javaResource.endpointConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        endpointGroupEndpointConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the AWS Region where the endpoint group is located.
     */
    public val endpointGroupRegion: Output<String>
        get() = javaResource.endpointGroupRegion().applyValue({ args0 -> args0 })

    /**
     * The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
     */
    public val healthCheckIntervalSeconds: Output<Int>?
        get() = javaResource.healthCheckIntervalSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (`/`). the provider will only perform drift detection of its value when present in a configuration.
     */
    public val healthCheckPath: Output<String>
        get() = javaResource.healthCheckPath().applyValue({ args0 -> args0 })

    /**
     * The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list.
     * the provider will only perform drift detection of its value when present in a configuration.
     */
    public val healthCheckPort: Output<Int>
        get() = javaResource.healthCheckPort().applyValue({ args0 -> args0 })

    /**
     * The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.
     */
    public val healthCheckProtocol: Output<String>?
        get() = javaResource.healthCheckProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    public val listenerArn: Output<String>
        get() = javaResource.listenerArn().applyValue({ args0 -> args0 })

    /**
     * Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. Fields documented below.
     */
    public val portOverrides: Output<List<EndpointGroupPortOverride>>?
        get() = javaResource.portOverrides().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        endpointGroupPortOverrideToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.
     */
    public val thresholdCount: Output<Int>?
        get() = javaResource.thresholdCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. The default value is 100.
     */
    public val trafficDialPercentage: Output<Double>?
        get() = javaResource.trafficDialPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object EndpointGroupMapper : ResourceMapper<EndpointGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.globalaccelerator.EndpointGroup::class == javaResource::class

    override fun map(javaResource: Resource): EndpointGroup = EndpointGroup(
        javaResource as
            com.pulumi.aws.globalaccelerator.EndpointGroup,
    )
}

/**
 * @see [EndpointGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointGroup].
 */
public suspend fun endpointGroup(
    name: String,
    block: suspend EndpointGroupResourceBuilder.() -> Unit,
): EndpointGroup {
    val builder = EndpointGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointGroup(name: String): EndpointGroup {
    val builder = EndpointGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
