@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.GlobalacceleratorFunctions.getAcceleratorPlain
import com.pulumi.aws.globalaccelerator.GlobalacceleratorFunctions.getCustomRoutingAcceleratorPlain
import com.pulumi.aws.globalaccelerator.kotlin.inputs.GetAcceleratorPlainArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.GetAcceleratorPlainArgsBuilder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.GetCustomRoutingAcceleratorPlainArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.GetCustomRoutingAcceleratorPlainArgsBuilder
import com.pulumi.aws.globalaccelerator.kotlin.outputs.GetAcceleratorResult
import com.pulumi.aws.globalaccelerator.kotlin.outputs.GetCustomRoutingAcceleratorResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.globalaccelerator.kotlin.outputs.GetAcceleratorResult.Companion.toKotlin as getAcceleratorResultToKotlin
import com.pulumi.aws.globalaccelerator.kotlin.outputs.GetCustomRoutingAcceleratorResult.Companion.toKotlin as getCustomRoutingAcceleratorResultToKotlin

public object GlobalacceleratorFunctions {
    /**
     * Provides information about a Global Accelerator accelerator.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const acceleratorArn = config.get("acceleratorArn") || "";
     * const acceleratorName = config.get("acceleratorName") || "";
     * const example = aws.globalaccelerator.getAccelerator({
     *     arn: acceleratorArn,
     *     name: acceleratorName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * accelerator_arn = config.get("acceleratorArn")
     * if accelerator_arn is None:
     *     accelerator_arn = ""
     * accelerator_name = config.get("acceleratorName")
     * if accelerator_name is None:
     *     accelerator_name = ""
     * example = aws.globalaccelerator.get_accelerator(arn=accelerator_arn,
     *     name=accelerator_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var acceleratorArn = config.Get("acceleratorArn") ?? "";
     *     var acceleratorName = config.Get("acceleratorName") ?? "";
     *     var example = Aws.GlobalAccelerator.GetAccelerator.Invoke(new()
     *     {
     *         Arn = acceleratorArn,
     *         Name = acceleratorName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		acceleratorArn := ""
     * 		if param := cfg.Get("acceleratorArn"); param != "" {
     * 			acceleratorArn = param
     * 		}
     * 		acceleratorName := ""
     * 		if param := cfg.Get("acceleratorName"); param != "" {
     * 			acceleratorName = param
     * 		}
     * 		_, err := globalaccelerator.LookupAccelerator(ctx, &globalaccelerator.LookupAcceleratorArgs{
     * 			Arn:  pulumi.StringRef(acceleratorArn),
     * 			Name: pulumi.StringRef(acceleratorName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.globalaccelerator.GlobalacceleratorFunctions;
     * import com.pulumi.aws.globalaccelerator.inputs.GetAcceleratorArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var acceleratorArn = config.get("acceleratorArn").orElse("");
     *         final var acceleratorName = config.get("acceleratorName").orElse("");
     *         final var example = GlobalacceleratorFunctions.getAccelerator(GetAcceleratorArgs.builder()
     *             .arn(acceleratorArn)
     *             .name(acceleratorName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   acceleratorArn:
     *     type: string
     *     default:
     *   acceleratorName:
     *     type: string
     *     default:
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:globalaccelerator:getAccelerator
     *       Arguments:
     *         arn: ${acceleratorArn}
     *         name: ${acceleratorName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccelerator.
     * @return A collection of values returned by getAccelerator.
     */
    public suspend fun getAccelerator(argument: GetAcceleratorPlainArgs): GetAcceleratorResult =
        getAcceleratorResultToKotlin(getAcceleratorPlain(argument.toJava()).await())

    /**
     * @see [getAccelerator].
     * @param arn Full ARN of the Global Accelerator.
     * @param id
     * @param name Unique name of the Global Accelerator.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     * @return A collection of values returned by getAccelerator.
     */
    public suspend fun getAccelerator(
        arn: String? = null,
        id: String? = null,
        name: String? = null,
    ): GetAcceleratorResult {
        val argument = GetAcceleratorPlainArgs(
            arn = arn,
            id = id,
            name = name,
        )
        return getAcceleratorResultToKotlin(getAcceleratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccelerator].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;globalaccelerator&#46;kotlin&#46;inputs&#46;GetAcceleratorPlainArgs].
     * @return A collection of values returned by getAccelerator.
     */
    public suspend fun getAccelerator(argument: suspend GetAcceleratorPlainArgsBuilder.() -> Unit): GetAcceleratorResult {
        val builder = GetAcceleratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAcceleratorResultToKotlin(getAcceleratorPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Global Accelerator custom routing accelerator.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const acceleratorArn = config.get("acceleratorArn") || "";
     * const acceleratorName = config.get("acceleratorName") || "";
     * const example = aws.globalaccelerator.getCustomRoutingAccelerator({
     *     arn: acceleratorArn,
     *     name: acceleratorName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * accelerator_arn = config.get("acceleratorArn")
     * if accelerator_arn is None:
     *     accelerator_arn = ""
     * accelerator_name = config.get("acceleratorName")
     * if accelerator_name is None:
     *     accelerator_name = ""
     * example = aws.globalaccelerator.get_custom_routing_accelerator(arn=accelerator_arn,
     *     name=accelerator_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var acceleratorArn = config.Get("acceleratorArn") ?? "";
     *     var acceleratorName = config.Get("acceleratorName") ?? "";
     *     var example = Aws.GlobalAccelerator.GetCustomRoutingAccelerator.Invoke(new()
     *     {
     *         Arn = acceleratorArn,
     *         Name = acceleratorName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		acceleratorArn := ""
     * 		if param := cfg.Get("acceleratorArn"); param != "" {
     * 			acceleratorArn = param
     * 		}
     * 		acceleratorName := ""
     * 		if param := cfg.Get("acceleratorName"); param != "" {
     * 			acceleratorName = param
     * 		}
     * 		_, err := globalaccelerator.LookupCustomRoutingAccelerator(ctx, &globalaccelerator.LookupCustomRoutingAcceleratorArgs{
     * 			Arn:  pulumi.StringRef(acceleratorArn),
     * 			Name: pulumi.StringRef(acceleratorName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.globalaccelerator.GlobalacceleratorFunctions;
     * import com.pulumi.aws.globalaccelerator.inputs.GetCustomRoutingAcceleratorArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var acceleratorArn = config.get("acceleratorArn").orElse("");
     *         final var acceleratorName = config.get("acceleratorName").orElse("");
     *         final var example = GlobalacceleratorFunctions.getCustomRoutingAccelerator(GetCustomRoutingAcceleratorArgs.builder()
     *             .arn(acceleratorArn)
     *             .name(acceleratorName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   acceleratorArn:
     *     type: string
     *     default:
     *   acceleratorName:
     *     type: string
     *     default:
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:globalaccelerator:getCustomRoutingAccelerator
     *       Arguments:
     *         arn: ${acceleratorArn}
     *         name: ${acceleratorName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomRoutingAccelerator.
     * @return A collection of values returned by getCustomRoutingAccelerator.
     */
    public suspend fun getCustomRoutingAccelerator(argument: GetCustomRoutingAcceleratorPlainArgs): GetCustomRoutingAcceleratorResult =
        getCustomRoutingAcceleratorResultToKotlin(getCustomRoutingAcceleratorPlain(argument.toJava()).await())

    /**
     * @see [getCustomRoutingAccelerator].
     * @param arn Full ARN of the custom routing accelerator.
     * @param name Unique name of the custom routing accelerator.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     * @param tags
     * @return A collection of values returned by getCustomRoutingAccelerator.
     */
    public suspend fun getCustomRoutingAccelerator(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetCustomRoutingAcceleratorResult {
        val argument = GetCustomRoutingAcceleratorPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getCustomRoutingAcceleratorResultToKotlin(getCustomRoutingAcceleratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomRoutingAccelerator].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;globalaccelerator&#46;kotlin&#46;inputs&#46;GetCustomRoutingAcceleratorPlainArgs].
     * @return A collection of values returned by getCustomRoutingAccelerator.
     */
    public suspend fun getCustomRoutingAccelerator(argument: suspend GetCustomRoutingAcceleratorPlainArgsBuilder.() -> Unit): GetCustomRoutingAcceleratorResult {
        val builder = GetCustomRoutingAcceleratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomRoutingAcceleratorResultToKotlin(getCustomRoutingAcceleratorPlain(builtArgument.toJava()).await())
    }
}
