@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin

import com.pulumi.aws.globalaccelerator.ListenerArgs.builder
import com.pulumi.aws.globalaccelerator.kotlin.inputs.ListenerPortRangeArgs
import com.pulumi.aws.globalaccelerator.kotlin.inputs.ListenerPortRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Global Accelerator listener.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.globalaccelerator.Accelerator("example", {
 *     name: "Example",
 *     ipAddressType: "IPV4",
 *     enabled: true,
 *     attributes: {
 *         flowLogsEnabled: true,
 *         flowLogsS3Bucket: "example-bucket",
 *         flowLogsS3Prefix: "flow-logs/",
 *     },
 * });
 * const exampleListener = new aws.globalaccelerator.Listener("example", {
 *     acceleratorArn: example.id,
 *     clientAffinity: "SOURCE_IP",
 *     protocol: "TCP",
 *     portRanges: [{
 *         fromPort: 80,
 *         toPort: 80,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.globalaccelerator.Accelerator("example",
 *     name="Example",
 *     ip_address_type="IPV4",
 *     enabled=True,
 *     attributes={
 *         "flow_logs_enabled": True,
 *         "flow_logs_s3_bucket": "example-bucket",
 *         "flow_logs_s3_prefix": "flow-logs/",
 *     })
 * example_listener = aws.globalaccelerator.Listener("example",
 *     accelerator_arn=example.id,
 *     client_affinity="SOURCE_IP",
 *     protocol="TCP",
 *     port_ranges=[{
 *         "from_port": 80,
 *         "to_port": 80,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GlobalAccelerator.Accelerator("example", new()
 *     {
 *         Name = "Example",
 *         IpAddressType = "IPV4",
 *         Enabled = true,
 *         Attributes = new Aws.GlobalAccelerator.Inputs.AcceleratorAttributesArgs
 *         {
 *             FlowLogsEnabled = true,
 *             FlowLogsS3Bucket = "example-bucket",
 *             FlowLogsS3Prefix = "flow-logs/",
 *         },
 *     });
 *     var exampleListener = new Aws.GlobalAccelerator.Listener("example", new()
 *     {
 *         AcceleratorArn = example.Id,
 *         ClientAffinity = "SOURCE_IP",
 *         Protocol = "TCP",
 *         PortRanges = new[]
 *         {
 *             new Aws.GlobalAccelerator.Inputs.ListenerPortRangeArgs
 *             {
 *                 FromPort = 80,
 *                 ToPort = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/globalaccelerator"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := globalaccelerator.NewAccelerator(ctx, "example", &globalaccelerator.AcceleratorArgs{
 * 			Name:          pulumi.String("Example"),
 * 			IpAddressType: pulumi.String("IPV4"),
 * 			Enabled:       pulumi.Bool(true),
 * 			Attributes: &globalaccelerator.AcceleratorAttributesArgs{
 * 				FlowLogsEnabled:  pulumi.Bool(true),
 * 				FlowLogsS3Bucket: pulumi.String("example-bucket"),
 * 				FlowLogsS3Prefix: pulumi.String("flow-logs/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = globalaccelerator.NewListener(ctx, "example", &globalaccelerator.ListenerArgs{
 * 			AcceleratorArn: example.ID(),
 * 			ClientAffinity: pulumi.String("SOURCE_IP"),
 * 			Protocol:       pulumi.String("TCP"),
 * 			PortRanges: globalaccelerator.ListenerPortRangeArray{
 * 				&globalaccelerator.ListenerPortRangeArgs{
 * 					FromPort: pulumi.Int(80),
 * 					ToPort:   pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.globalaccelerator.Accelerator;
 * import com.pulumi.aws.globalaccelerator.AcceleratorArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs;
 * import com.pulumi.aws.globalaccelerator.Listener;
 * import com.pulumi.aws.globalaccelerator.ListenerArgs;
 * import com.pulumi.aws.globalaccelerator.inputs.ListenerPortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Accelerator("example", AcceleratorArgs.builder()
 *             .name("Example")
 *             .ipAddressType("IPV4")
 *             .enabled(true)
 *             .attributes(AcceleratorAttributesArgs.builder()
 *                 .flowLogsEnabled(true)
 *                 .flowLogsS3Bucket("example-bucket")
 *                 .flowLogsS3Prefix("flow-logs/")
 *                 .build())
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .acceleratorArn(example.id())
 *             .clientAffinity("SOURCE_IP")
 *             .protocol("TCP")
 *             .portRanges(ListenerPortRangeArgs.builder()
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:globalaccelerator:Accelerator
 *     properties:
 *       name: Example
 *       ipAddressType: IPV4
 *       enabled: true
 *       attributes:
 *         flowLogsEnabled: true
 *         flowLogsS3Bucket: example-bucket
 *         flowLogsS3Prefix: flow-logs/
 *   exampleListener:
 *     type: aws:globalaccelerator:Listener
 *     name: example
 *     properties:
 *       acceleratorArn: ${example.id}
 *       clientAffinity: SOURCE_IP
 *       protocol: TCP
 *       portRanges:
 *         - fromPort: 80
 *           toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Global Accelerator listeners using the `id`. For example:
 * ```sh
 * $ pulumi import aws:globalaccelerator/listener:Listener example arn:aws:globalaccelerator::111111111111:accelerator/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/listener/xxxxxxxx
 * ```
 * @property acceleratorArn The Amazon Resource Name (ARN) of your accelerator.
 * @property clientAffinity Direct all requests from a user to the same endpoint. Valid values are `NONE`, `SOURCE_IP`. Default: `NONE`. If `NONE`, Global Accelerator uses the "five-tuple" properties of source IP address, source port, destination IP address, destination port, and protocol to select the hash value. If `SOURCE_IP`, Global Accelerator uses the "two-tuple" properties of source (client) IP address and destination IP address to select the hash value.
 * @property portRanges The list of port ranges for the connections from clients to the accelerator. Fields documented below.
 * @property protocol The protocol for the connections from clients to the accelerator. Valid values are `TCP`, `UDP`.
 */
public data class ListenerArgs(
    public val acceleratorArn: Output<String>? = null,
    public val clientAffinity: Output<String>? = null,
    public val portRanges: Output<List<ListenerPortRangeArgs>>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.ListenerArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.ListenerArgs =
        com.pulumi.aws.globalaccelerator.ListenerArgs.builder()
            .acceleratorArn(acceleratorArn?.applyValue({ args0 -> args0 }))
            .clientAffinity(clientAffinity?.applyValue({ args0 -> args0 }))
            .portRanges(
                portRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerArgs].
 */
@PulumiTagMarker
public class ListenerArgsBuilder internal constructor() {
    private var acceleratorArn: Output<String>? = null

    private var clientAffinity: Output<String>? = null

    private var portRanges: Output<List<ListenerPortRangeArgs>>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of your accelerator.
     */
    @JvmName("bssenmandcsdnhcf")
    public suspend fun acceleratorArn(`value`: Output<String>) {
        this.acceleratorArn = value
    }

    /**
     * @param value Direct all requests from a user to the same endpoint. Valid values are `NONE`, `SOURCE_IP`. Default: `NONE`. If `NONE`, Global Accelerator uses the "five-tuple" properties of source IP address, source port, destination IP address, destination port, and protocol to select the hash value. If `SOURCE_IP`, Global Accelerator uses the "two-tuple" properties of source (client) IP address and destination IP address to select the hash value.
     */
    @JvmName("tepruiprwcqcuock")
    public suspend fun clientAffinity(`value`: Output<String>) {
        this.clientAffinity = value
    }

    /**
     * @param value The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("jmofsmdrkltsyavd")
    public suspend fun portRanges(`value`: Output<List<ListenerPortRangeArgs>>) {
        this.portRanges = value
    }

    @JvmName("gcgmkgoawiuclqxo")
    public suspend fun portRanges(vararg values: Output<ListenerPortRangeArgs>) {
        this.portRanges = Output.all(values.asList())
    }

    /**
     * @param values The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("noegieeruevkxpts")
    public suspend fun portRanges(values: List<Output<ListenerPortRangeArgs>>) {
        this.portRanges = Output.all(values)
    }

    /**
     * @param value The protocol for the connections from clients to the accelerator. Valid values are `TCP`, `UDP`.
     */
    @JvmName("jdjrgkfulmchkuni")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of your accelerator.
     */
    @JvmName("chemhayyymgetbsj")
    public suspend fun acceleratorArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorArn = mapped
    }

    /**
     * @param value Direct all requests from a user to the same endpoint. Valid values are `NONE`, `SOURCE_IP`. Default: `NONE`. If `NONE`, Global Accelerator uses the "five-tuple" properties of source IP address, source port, destination IP address, destination port, and protocol to select the hash value. If `SOURCE_IP`, Global Accelerator uses the "two-tuple" properties of source (client) IP address and destination IP address to select the hash value.
     */
    @JvmName("ifvmbsuqsfifbjxq")
    public suspend fun clientAffinity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAffinity = mapped
    }

    /**
     * @param value The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("hhhhaxevrmdrmccm")
    public suspend fun portRanges(`value`: List<ListenerPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("dxilxmnmtjebigre")
    public suspend fun portRanges(argument: List<suspend ListenerPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerPortRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("bkoxttjtvsdkfloq")
    public suspend fun portRanges(vararg argument: suspend ListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerPortRangeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param argument The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("xndnbvaiqnbjgtvd")
    public suspend fun portRanges(argument: suspend ListenerPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ListenerPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.portRanges = mapped
    }

    /**
     * @param values The list of port ranges for the connections from clients to the accelerator. Fields documented below.
     */
    @JvmName("tptimlqynvwrtgki")
    public suspend fun portRanges(vararg values: ListenerPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portRanges = mapped
    }

    /**
     * @param value The protocol for the connections from clients to the accelerator. Valid values are `TCP`, `UDP`.
     */
    @JvmName("kehyuajqoqfqiofp")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): ListenerArgs = ListenerArgs(
        acceleratorArn = acceleratorArn,
        clientAffinity = clientAffinity,
        portRanges = portRanges,
        protocol = protocol,
    )
}
