@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property flowLogsEnabled Indicates whether flow logs are enabled. Defaults to `false`. Valid values: `true`, `false`.
 * @property flowLogsS3Bucket The name of the Amazon S3 bucket for the flow logs. Required if `flow_logs_enabled` is `true`.
 * @property flowLogsS3Prefix The prefix for the location in the Amazon S3 bucket for the flow logs. Required if `flow_logs_enabled` is `true`.
 */
public data class AcceleratorAttributesArgs(
    public val flowLogsEnabled: Output<Boolean>? = null,
    public val flowLogsS3Bucket: Output<String>? = null,
    public val flowLogsS3Prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs =
        com.pulumi.aws.globalaccelerator.inputs.AcceleratorAttributesArgs.builder()
            .flowLogsEnabled(flowLogsEnabled?.applyValue({ args0 -> args0 }))
            .flowLogsS3Bucket(flowLogsS3Bucket?.applyValue({ args0 -> args0 }))
            .flowLogsS3Prefix(flowLogsS3Prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AcceleratorAttributesArgs].
 */
@PulumiTagMarker
public class AcceleratorAttributesArgsBuilder internal constructor() {
    private var flowLogsEnabled: Output<Boolean>? = null

    private var flowLogsS3Bucket: Output<String>? = null

    private var flowLogsS3Prefix: Output<String>? = null

    /**
     * @param value Indicates whether flow logs are enabled. Defaults to `false`. Valid values: `true`, `false`.
     */
    @JvmName("gtpxlikjuipokuxy")
    public suspend fun flowLogsEnabled(`value`: Output<Boolean>) {
        this.flowLogsEnabled = value
    }

    /**
     * @param value The name of the Amazon S3 bucket for the flow logs. Required if `flow_logs_enabled` is `true`.
     */
    @JvmName("mplsmcpdanrrdlee")
    public suspend fun flowLogsS3Bucket(`value`: Output<String>) {
        this.flowLogsS3Bucket = value
    }

    /**
     * @param value The prefix for the location in the Amazon S3 bucket for the flow logs. Required if `flow_logs_enabled` is `true`.
     */
    @JvmName("phuenlhuxhpbsncw")
    public suspend fun flowLogsS3Prefix(`value`: Output<String>) {
        this.flowLogsS3Prefix = value
    }

    /**
     * @param value Indicates whether flow logs are enabled. Defaults to `false`. Valid values: `true`, `false`.
     */
    @JvmName("sjocndcbuawhvvuu")
    public suspend fun flowLogsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowLogsEnabled = mapped
    }

    /**
     * @param value The name of the Amazon S3 bucket for the flow logs. Required if `flow_logs_enabled` is `true`.
     */
    @JvmName("nevajmdnsngjnjyq")
    public suspend fun flowLogsS3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowLogsS3Bucket = mapped
    }

    /**
     * @param value The prefix for the location in the Amazon S3 bucket for the flow logs. Required if `flow_logs_enabled` is `true`.
     */
    @JvmName("jucpcbknmyjxcirb")
    public suspend fun flowLogsS3Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowLogsS3Prefix = mapped
    }

    internal fun build(): AcceleratorAttributesArgs = AcceleratorAttributesArgs(
        flowLogsEnabled = flowLogsEnabled,
        flowLogsS3Bucket = flowLogsS3Bucket,
        flowLogsS3Prefix = flowLogsS3Prefix,
    )
}
