@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.CrossAccountAttachmentResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlock IP address range, in CIDR format, that is specified as resource.
 * @property endpointId The endpoint ID for the endpoint that is specified as a AWS resource.
 * @property region The AWS Region where a shared endpoint resource is located.
 */
public data class CrossAccountAttachmentResourceArgs(
    public val cidrBlock: Output<String>? = null,
    public val endpointId: Output<String>? = null,
    public val region: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.CrossAccountAttachmentResourceArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.inputs.CrossAccountAttachmentResourceArgs = com.pulumi.aws.globalaccelerator.inputs.CrossAccountAttachmentResourceArgs.builder()
        .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
        .endpointId(endpointId?.applyValue({ args0 -> args0 }))
        .region(region?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrossAccountAttachmentResourceArgs].
 */
@PulumiTagMarker
public class CrossAccountAttachmentResourceArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var endpointId: Output<String>? = null

    private var region: Output<String>? = null

    /**
     * @param value IP address range, in CIDR format, that is specified as resource.
     */
    @JvmName("mniwhndufdaoednm")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The endpoint ID for the endpoint that is specified as a AWS resource.
     */
    @JvmName("poynbtnpksxpymwe")
    public suspend fun endpointId(`value`: Output<String>) {
        this.endpointId = value
    }

    /**
     * @param value The AWS Region where a shared endpoint resource is located.
     */
    @JvmName("rgaqtbqfsjcybimj")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value IP address range, in CIDR format, that is specified as resource.
     */
    @JvmName("xsidulxektnfyinv")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The endpoint ID for the endpoint that is specified as a AWS resource.
     */
    @JvmName("nswmshmlownxgqom")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointId = mapped
    }

    /**
     * @param value The AWS Region where a shared endpoint resource is located.
     */
    @JvmName("wphjoqpdbmqgygvn")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): CrossAccountAttachmentResourceArgs = CrossAccountAttachmentResourceArgs(
        cidrBlock = cidrBlock,
        endpointId = endpointId,
        region = region,
    )
}
