@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fromPort The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.
 * @property protocols The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either `"TCP"` or `"UDP"`.
 * @property toPort The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.
 */
public data class CustomRoutingEndpointGroupDestinationConfigurationArgs(
    public val fromPort: Output<Int>,
    public val protocols: Output<List<String>>,
    public val toPort: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs =
        com.pulumi.aws.globalaccelerator.inputs.CustomRoutingEndpointGroupDestinationConfigurationArgs.builder()
            .fromPort(fromPort.applyValue({ args0 -> args0 }))
            .protocols(protocols.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .toPort(toPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRoutingEndpointGroupDestinationConfigurationArgs].
 */
@PulumiTagMarker
public class CustomRoutingEndpointGroupDestinationConfigurationArgsBuilder internal constructor() {
    private var fromPort: Output<Int>? = null

    private var protocols: Output<List<String>>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.
     */
    @JvmName("rcagtggqktoxqshu")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either `"TCP"` or `"UDP"`.
     */
    @JvmName("xyfabreeobxbjjqo")
    public suspend fun protocols(`value`: Output<List<String>>) {
        this.protocols = value
    }

    @JvmName("jqqifnwadatevtoj")
    public suspend fun protocols(vararg values: Output<String>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either `"TCP"` or `"UDP"`.
     */
    @JvmName("wghcflvppgvwkcki")
    public suspend fun protocols(values: List<Output<String>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.
     */
    @JvmName("mrinicvhphxnvqsp")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.
     */
    @JvmName("npkbyqdaplmydqqn")
    public suspend fun fromPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either `"TCP"` or `"UDP"`.
     */
    @JvmName("vokjogrucixjqkdf")
    public suspend fun protocols(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param values The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either `"TCP"` or `"UDP"`.
     */
    @JvmName("nnpwrktikwrvnkgc")
    public suspend fun protocols(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.
     */
    @JvmName("lxcdpoucrovedlkk")
    public suspend fun toPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): CustomRoutingEndpointGroupDestinationConfigurationArgs =
        CustomRoutingEndpointGroupDestinationConfigurationArgs(
            fromPort = fromPort ?: throw PulumiNullFieldException("fromPort"),
            protocols = protocols ?: throw PulumiNullFieldException("protocols"),
            toPort = toPort ?: throw PulumiNullFieldException("toPort"),
        )
}
