@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.CustomRoutingListenerPortRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fromPort The first port in the range of ports, inclusive.
 * @property toPort The last port in the range of ports, inclusive.
 */
public data class CustomRoutingListenerPortRangeArgs(
    public val fromPort: Output<Int>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.CustomRoutingListenerPortRangeArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.inputs.CustomRoutingListenerPortRangeArgs = com.pulumi.aws.globalaccelerator.inputs.CustomRoutingListenerPortRangeArgs.builder()
        .fromPort(fromPort?.applyValue({ args0 -> args0 }))
        .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomRoutingListenerPortRangeArgs].
 */
@PulumiTagMarker
public class CustomRoutingListenerPortRangeArgsBuilder internal constructor() {
    private var fromPort: Output<Int>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The first port in the range of ports, inclusive.
     */
    @JvmName("bmgovjueothrfqdb")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The last port in the range of ports, inclusive.
     */
    @JvmName("iilpelrqrwtqujqm")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The first port in the range of ports, inclusive.
     */
    @JvmName("kqnuxrriqivbrsgs")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The last port in the range of ports, inclusive.
     */
    @JvmName("uvqsveajiudehrdo")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): CustomRoutingListenerPortRangeArgs = CustomRoutingListenerPortRangeArgs(
        fromPort = fromPort,
        toPort = toPort,
    )
}
