@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.EndpointGroupPortOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointPort The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
 * @property listenerPort The listener port that you want to map to a specific endpoint port. This is the port that user traffic arrives to the Global Accelerator on.
 */
public data class EndpointGroupPortOverrideArgs(
    public val endpointPort: Output<Int>,
    public val listenerPort: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.EndpointGroupPortOverrideArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.inputs.EndpointGroupPortOverrideArgs =
        com.pulumi.aws.globalaccelerator.inputs.EndpointGroupPortOverrideArgs.builder()
            .endpointPort(endpointPort.applyValue({ args0 -> args0 }))
            .listenerPort(listenerPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointGroupPortOverrideArgs].
 */
@PulumiTagMarker
public class EndpointGroupPortOverrideArgsBuilder internal constructor() {
    private var endpointPort: Output<Int>? = null

    private var listenerPort: Output<Int>? = null

    /**
     * @param value The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
     */
    @JvmName("xyjfukuxxejhcyrp")
    public suspend fun endpointPort(`value`: Output<Int>) {
        this.endpointPort = value
    }

    /**
     * @param value The listener port that you want to map to a specific endpoint port. This is the port that user traffic arrives to the Global Accelerator on.
     */
    @JvmName("duwaeretrpadkbsa")
    public suspend fun listenerPort(`value`: Output<Int>) {
        this.listenerPort = value
    }

    /**
     * @param value The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
     */
    @JvmName("jhwpxjdqoddkidar")
    public suspend fun endpointPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointPort = mapped
    }

    /**
     * @param value The listener port that you want to map to a specific endpoint port. This is the port that user traffic arrives to the Global Accelerator on.
     */
    @JvmName("jtvxnjtrcbswysih")
    public suspend fun listenerPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listenerPort = mapped
    }

    internal fun build(): EndpointGroupPortOverrideArgs = EndpointGroupPortOverrideArgs(
        endpointPort = endpointPort ?: throw PulumiNullFieldException("endpointPort"),
        listenerPort = listenerPort ?: throw PulumiNullFieldException("listenerPort"),
    )
}
