@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.GetAcceleratorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccelerator.
 * @property arn Full ARN of the Global Accelerator.
 * @property id
 * @property name Unique name of the Global Accelerator.
 * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
 */
public data class GetAcceleratorPlainArgs(
    public val arn: String? = null,
    public val id: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.GetAcceleratorPlainArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.inputs.GetAcceleratorPlainArgs =
        com.pulumi.aws.globalaccelerator.inputs.GetAcceleratorPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAcceleratorPlainArgs].
 */
@PulumiTagMarker
public class GetAcceleratorPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var id: String? = null

    private var name: String? = null

    /**
     * @param value Full ARN of the Global Accelerator.
     */
    @JvmName("gcivrdrjoxydndeq")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value
     */
    @JvmName("dwgxopmxejwgorof")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Unique name of the Global Accelerator.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     */
    @JvmName("ffddndhpmgkrbcyh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetAcceleratorPlainArgs = GetAcceleratorPlainArgs(
        arn = arn,
        id = id,
        name = name,
    )
}
