@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.inputs

import com.pulumi.aws.globalaccelerator.inputs.GetCustomRoutingAcceleratorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomRoutingAccelerator.
 * @property arn Full ARN of the custom routing accelerator.
 * @property name Unique name of the custom routing accelerator.
 * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
 * @property tags
 */
public data class GetCustomRoutingAcceleratorPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.globalaccelerator.inputs.GetCustomRoutingAcceleratorPlainArgs> {
    override fun toJava(): com.pulumi.aws.globalaccelerator.inputs.GetCustomRoutingAcceleratorPlainArgs =
        com.pulumi.aws.globalaccelerator.inputs.GetCustomRoutingAcceleratorPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetCustomRoutingAcceleratorPlainArgs].
 */
@PulumiTagMarker
public class GetCustomRoutingAcceleratorPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Full ARN of the custom routing accelerator.
     */
    @JvmName("bgapecxpkevfpkyf")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Unique name of the custom routing accelerator.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     */
    @JvmName("oxsctsodcaltoxkx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("viecfvbhdbrijuqt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("kvbwwcdlxmxmgbuh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetCustomRoutingAcceleratorPlainArgs = GetCustomRoutingAcceleratorPlainArgs(
        arn = arn,
        name = name,
        tags = tags,
    )
}
