@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock IP address range, in CIDR format, that is specified as resource.
 * @property endpointId The endpoint ID for the endpoint that is specified as a AWS resource.
 * @property region The AWS Region where a shared endpoint resource is located.
 */
public data class CrossAccountAttachmentResource(
    public val cidrBlock: String? = null,
    public val endpointId: String? = null,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.globalaccelerator.outputs.CrossAccountAttachmentResource): CrossAccountAttachmentResource = CrossAccountAttachmentResource(
            cidrBlock = javaType.cidrBlock().map({ args0 -> args0 }).orElse(null),
            endpointId = javaType.endpointId().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
