@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ipAddresses The IP addresses to use for BYOIP accelerators. If not specified, the service assigns IP addresses. Valid values: 1 or 2 IPv4 addresses.
 * @property ipFamily The type of IP addresses included in this IP set.
 */
public data class CustomRoutingAcceleratorIpSet(
    public val ipAddresses: List<String>? = null,
    public val ipFamily: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.globalaccelerator.outputs.CustomRoutingAcceleratorIpSet): CustomRoutingAcceleratorIpSet = CustomRoutingAcceleratorIpSet(
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            ipFamily = javaType.ipFamily().map({ args0 -> args0 }).orElse(null),
        )
    }
}
