@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.globalaccelerator.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property endpointPort The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
 * @property listenerPort The listener port that you want to map to a specific endpoint port. This is the port that user traffic arrives to the Global Accelerator on.
 */
public data class EndpointGroupPortOverride(
    public val endpointPort: Int,
    public val listenerPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.globalaccelerator.outputs.EndpointGroupPortOverride): EndpointGroupPortOverride = EndpointGroupPortOverride(
            endpointPort = javaType.endpointPort(),
            listenerPort = javaType.listenerPort(),
        )
    }
}
