@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.CatalogDatabaseArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseCreateTableDefaultPermissionArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseFederatedDatabaseArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseFederatedDatabaseArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseTargetDatabaseArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogDatabaseTargetDatabaseArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Catalog Database Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.CatalogDatabase("example", {name: "MyCatalogDatabase"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.CatalogDatabase("example", name="MyCatalogDatabase")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.CatalogDatabase("example", new()
 *     {
 *         Name = "MyCatalogDatabase",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCatalogDatabase(ctx, "example", &glue.CatalogDatabaseArgs{
 * 			Name: pulumi.String("MyCatalogDatabase"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CatalogDatabase("example", CatalogDatabaseArgs.builder()
 *             .name("MyCatalogDatabase")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:CatalogDatabase
 *     properties:
 *       name: MyCatalogDatabase
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create Table Default Permissions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.CatalogDatabase("example", {
 *     name: "MyCatalogDatabase",
 *     createTableDefaultPermissions: [{
 *         permissions: ["SELECT"],
 *         principal: {
 *             dataLakePrincipalIdentifier: "IAM_ALLOWED_PRINCIPALS",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.CatalogDatabase("example",
 *     name="MyCatalogDatabase",
 *     create_table_default_permissions=[{
 *         "permissions": ["SELECT"],
 *         "principal": {
 *             "data_lake_principal_identifier": "IAM_ALLOWED_PRINCIPALS",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.CatalogDatabase("example", new()
 *     {
 *         Name = "MyCatalogDatabase",
 *         CreateTableDefaultPermissions = new[]
 *         {
 *             new Aws.Glue.Inputs.CatalogDatabaseCreateTableDefaultPermissionArgs
 *             {
 *                 Permissions = new[]
 *                 {
 *                     "SELECT",
 *                 },
 *                 Principal = new Aws.Glue.Inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs
 *                 {
 *                     DataLakePrincipalIdentifier = "IAM_ALLOWED_PRINCIPALS",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCatalogDatabase(ctx, "example", &glue.CatalogDatabaseArgs{
 * 			Name: pulumi.String("MyCatalogDatabase"),
 * 			CreateTableDefaultPermissions: glue.CatalogDatabaseCreateTableDefaultPermissionArray{
 * 				&glue.CatalogDatabaseCreateTableDefaultPermissionArgs{
 * 					Permissions: pulumi.StringArray{
 * 						pulumi.String("SELECT"),
 * 					},
 * 					Principal: &glue.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs{
 * 						DataLakePrincipalIdentifier: pulumi.String("IAM_ALLOWED_PRINCIPALS"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs;
 * import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CatalogDatabase("example", CatalogDatabaseArgs.builder()
 *             .name("MyCatalogDatabase")
 *             .createTableDefaultPermissions(CatalogDatabaseCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("SELECT")
 *                 .principal(CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs.builder()
 *                     .dataLakePrincipalIdentifier("IAM_ALLOWED_PRINCIPALS")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:CatalogDatabase
 *     properties:
 *       name: MyCatalogDatabase
 *       createTableDefaultPermissions:
 *         - permissions:
 *             - SELECT
 *           principal:
 *             dataLakePrincipalIdentifier: IAM_ALLOWED_PRINCIPALS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Catalog Databases using the `catalog_id:name`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * ```sh
 * $ pulumi import aws:glue/catalogDatabase:CatalogDatabase database 123456789012:my_database
 * ```
 * @property catalogId ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
 * @property createTableDefaultPermissions Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
 * @property description Description of the database.
 * @property federatedDatabase Configuration block that references an entity outside the AWS Glue Data Catalog. See `federated_database` below.
 * @property locationUri Location of the database (for example, an HDFS path).
 * @property name Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
 * @property parameters List of key-value pairs that define parameters and properties of the database.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetDatabase Configuration block for a target database for resource linking. See `target_database` below.
 */
public data class CatalogDatabaseArgs(
    public val catalogId: Output<String>? = null,
    public val createTableDefaultPermissions: Output<List<CatalogDatabaseCreateTableDefaultPermissionArgs>>? = null,
    public val description: Output<String>? = null,
    public val federatedDatabase: Output<CatalogDatabaseFederatedDatabaseArgs>? = null,
    public val locationUri: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetDatabase: Output<CatalogDatabaseTargetDatabaseArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.CatalogDatabaseArgs> {
    override fun toJava(): com.pulumi.aws.glue.CatalogDatabaseArgs =
        com.pulumi.aws.glue.CatalogDatabaseArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .createTableDefaultPermissions(
                createTableDefaultPermissions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .federatedDatabase(federatedDatabase?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .locationUri(locationUri?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetDatabase(
                targetDatabase?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CatalogDatabaseArgs].
 */
@PulumiTagMarker
public class CatalogDatabaseArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var createTableDefaultPermissions:
        Output<List<CatalogDatabaseCreateTableDefaultPermissionArgs>>? = null

    private var description: Output<String>? = null

    private var federatedDatabase: Output<CatalogDatabaseFederatedDatabaseArgs>? = null

    private var locationUri: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetDatabase: Output<CatalogDatabaseTargetDatabaseArgs>? = null

    /**
     * @param value ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("iggqqjrrteluuhhc")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("gpaaiuahlkgauqoa")
    public suspend fun createTableDefaultPermissions(`value`: Output<List<CatalogDatabaseCreateTableDefaultPermissionArgs>>) {
        this.createTableDefaultPermissions = value
    }

    @JvmName("vrrumddxeknfhyil")
    public suspend fun createTableDefaultPermissions(vararg values: Output<CatalogDatabaseCreateTableDefaultPermissionArgs>) {
        this.createTableDefaultPermissions = Output.all(values.asList())
    }

    /**
     * @param values Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("iwloiikgekervlvo")
    public suspend fun createTableDefaultPermissions(values: List<Output<CatalogDatabaseCreateTableDefaultPermissionArgs>>) {
        this.createTableDefaultPermissions = Output.all(values)
    }

    /**
     * @param value Description of the database.
     */
    @JvmName("pilylegoxuqvxger")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Configuration block that references an entity outside the AWS Glue Data Catalog. See `federated_database` below.
     */
    @JvmName("apshrhybqkckmeml")
    public suspend fun federatedDatabase(`value`: Output<CatalogDatabaseFederatedDatabaseArgs>) {
        this.federatedDatabase = value
    }

    /**
     * @param value Location of the database (for example, an HDFS path).
     */
    @JvmName("qspplawsfllrsorh")
    public suspend fun locationUri(`value`: Output<String>) {
        this.locationUri = value
    }

    /**
     * @param value Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
     */
    @JvmName("nvoryvugfocojfey")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of key-value pairs that define parameters and properties of the database.
     */
    @JvmName("fglksbvsrhbupbyl")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ssqtjokycmqcgujq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for a target database for resource linking. See `target_database` below.
     */
    @JvmName("bvfhgccheoyaoejv")
    public suspend fun targetDatabase(`value`: Output<CatalogDatabaseTargetDatabaseArgs>) {
        this.targetDatabase = value
    }

    /**
     * @param value ID of the Glue Catalog to create the database in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("glttjonvhbukfenh")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("gcewtfnpxowfejmc")
    public suspend fun createTableDefaultPermissions(`value`: List<CatalogDatabaseCreateTableDefaultPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("vgaajwmfnxbaqpkl")
    public suspend fun createTableDefaultPermissions(argument: List<suspend CatalogDatabaseCreateTableDefaultPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CatalogDatabaseCreateTableDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("ggwbquhqcaqtikvp")
    public suspend fun createTableDefaultPermissions(vararg argument: suspend CatalogDatabaseCreateTableDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CatalogDatabaseCreateTableDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("dajjbxnncudblbus")
    public suspend fun createTableDefaultPermissions(argument: suspend CatalogDatabaseCreateTableDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CatalogDatabaseCreateTableDefaultPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param values Creates a set of default permissions on the table for principals. See `create_table_default_permission` below.
     */
    @JvmName("rxejqukcarjgymgh")
    public suspend fun createTableDefaultPermissions(vararg values: CatalogDatabaseCreateTableDefaultPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param value Description of the database.
     */
    @JvmName("cislbcfoultiujdn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Configuration block that references an entity outside the AWS Glue Data Catalog. See `federated_database` below.
     */
    @JvmName("hwvawnkqoiwkohlm")
    public suspend fun federatedDatabase(`value`: CatalogDatabaseFederatedDatabaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.federatedDatabase = mapped
    }

    /**
     * @param argument Configuration block that references an entity outside the AWS Glue Data Catalog. See `federated_database` below.
     */
    @JvmName("hgvxthpyvckftdag")
    public suspend fun federatedDatabase(argument: suspend CatalogDatabaseFederatedDatabaseArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogDatabaseFederatedDatabaseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.federatedDatabase = mapped
    }

    /**
     * @param value Location of the database (for example, an HDFS path).
     */
    @JvmName("gmxkdaoocpndehlu")
    public suspend fun locationUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationUri = mapped
    }

    /**
     * @param value Name of the database. The acceptable characters are lowercase letters, numbers, and the underscore character.
     */
    @JvmName("mhxidhktbswqjgxf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of key-value pairs that define parameters and properties of the database.
     */
    @JvmName("xwynpqygppvqrtql")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values List of key-value pairs that define parameters and properties of the database.
     */
    @JvmName("gsydgnbsaohoemwt")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bgmvfoghmkvixkao")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kwxyfdxtelvfyhdr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block for a target database for resource linking. See `target_database` below.
     */
    @JvmName("vtudlhinbyxdllyh")
    public suspend fun targetDatabase(`value`: CatalogDatabaseTargetDatabaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabase = mapped
    }

    /**
     * @param argument Configuration block for a target database for resource linking. See `target_database` below.
     */
    @JvmName("hqtgwlmuhsjvhhln")
    public suspend fun targetDatabase(argument: suspend CatalogDatabaseTargetDatabaseArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogDatabaseTargetDatabaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetDatabase = mapped
    }

    internal fun build(): CatalogDatabaseArgs = CatalogDatabaseArgs(
        catalogId = catalogId,
        createTableDefaultPermissions = createTableDefaultPermissions,
        description = description,
        federatedDatabase = federatedDatabase,
        locationUri = locationUri,
        name = name,
        parameters = parameters,
        tags = tags,
        targetDatabase = targetDatabase,
    )
}
